/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.Ordered;
import cn.taketoday.context.OrderedSupport;
import cn.taketoday.context.Scope;
import cn.taketoday.context.aware.BeanClassLoaderAware;
import cn.taketoday.context.factory.BeanFactoryPostProcessor;
import cn.taketoday.context.factory.ConfigurableBeanFactory;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import java.util.LinkedHashMap;
import java.util.Map;

public class CustomScopeConfigurer
extends OrderedSupport
implements BeanFactoryPostProcessor,
BeanClassLoaderAware,
Ordered {
    private Map<String, Object> scopes;
    private ClassLoader beanClassLoader = ClassUtils.getClassLoader();

    public void setScopes(Map<String, Object> scopes) {
        this.scopes = scopes;
    }

    public void addScope(String scopeName, Scope scope) {
        if (this.scopes == null) {
            this.scopes = new LinkedHashMap<String, Object>(1);
        }
        this.scopes.put(scopeName, scope);
    }

    @Override
    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Override
    public void postProcessBeanFactory(ConfigurableBeanFactory beanFactory) {
        if (this.scopes != null) {
            this.scopes.forEach((name, scope) -> {
                if (scope instanceof Scope) {
                    beanFactory.registerScope((String)name, (Scope)scope);
                } else if (scope instanceof Class) {
                    Class scopeClass = (Class)scope;
                    Assert.isAssignable(Scope.class, scopeClass, "Invalid scope class");
                    beanFactory.registerScope((String)name, (Scope)ClassUtils.newInstance(scopeClass));
                } else if (scope instanceof String) {
                    Class scopeClass = ClassUtils.loadClass((String)scope, this.beanClassLoader);
                    Assert.isAssignable(Scope.class, scopeClass, "Invalid scope class");
                    beanFactory.registerScope((String)name, (Scope)ClassUtils.newInstance(scopeClass));
                } else {
                    throw new IllegalArgumentException("Mapped value [" + scope + "] for scope key [" + name + "] is not an instance of required type [" + Scope.class.getName() + "] or a corresponding Class or String value indicating a Scope implementation");
                }
            });
        }
    }
}

