/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.TypeConverter;
import cn.taketoday.context.conversion.support.DefaultConversionService;
import cn.taketoday.context.exception.NoSuchPropertyException;
import cn.taketoday.context.factory.BeanMetadata;
import cn.taketoday.context.factory.BeanProperty;
import cn.taketoday.context.factory.InvalidPropertyValueException;
import cn.taketoday.context.factory.PropertyReadOnlyException;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.CollectionUtils;
import cn.taketoday.context.utils.GenericDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeanPropertyAccessor {
    protected Object rootObject;
    protected BeanMetadata metadata;
    private boolean ignoreUnknownProperty = true;
    private boolean throwsWhenReadOnly = true;
    private ConversionService conversionService;

    public BeanPropertyAccessor() {
        this.conversionService = DefaultConversionService.getSharedInstance();
    }

    public BeanPropertyAccessor(Class<?> beanClass) {
        this(beanClass, DefaultConversionService.getSharedInstance());
    }

    public BeanPropertyAccessor(Class<?> beanClass, ConversionService conversionService) {
        BeanMetadata metadata = BeanMetadata.ofClass(beanClass);
        this.rootObject = metadata.newInstance();
        this.metadata = metadata;
        this.conversionService = conversionService;
    }

    public BeanPropertyAccessor(Object rootObject) {
        this(BeanMetadata.ofObject(rootObject), rootObject);
    }

    public BeanPropertyAccessor(BeanMetadata metadata, Object rootObject) {
        this();
        this.metadata = metadata;
        this.rootObject = rootObject;
    }

    public <T> T getProperty(String propertyPath, Class<T> requiredType) {
        return (T)this.convertIfNecessary(this.getProperty(propertyPath), requiredType);
    }

    public Object getProperty(String propertyPath) {
        return BeanPropertyAccessor.getProperty(this.getRootObject(), this.obtainMetadata(), propertyPath);
    }

    public static Object getProperty(Object root, String propertyPath) {
        return BeanPropertyAccessor.getProperty(root, BeanMetadata.ofObject(root), propertyPath);
    }

    public static Object getProperty(Object root, BeanMetadata metadata, String propertyPath) {
        int signIndex = BeanPropertyAccessor.getNestedPropertySeparatorIndex(propertyPath);
        if (signIndex != -1) {
            String property = propertyPath.substring(0, signIndex);
            Object propertyValue = BeanPropertyAccessor.getPropertyValue(root, metadata, property);
            if (propertyValue == null) {
                return null;
            }
            BeanMetadata subMetadata = BeanPropertyAccessor.getSubBeanMetadata(metadata, property, propertyValue);
            String newPath = propertyPath.substring(signIndex + 1);
            return BeanPropertyAccessor.getProperty(propertyValue, subMetadata, newPath);
        }
        return BeanPropertyAccessor.getPropertyValue(root, metadata, propertyPath);
    }

    private static BeanMetadata getSubBeanMetadata(BeanMetadata root, String property, Object propertyValue) {
        if (property.indexOf(91) != -1) {
            return BeanMetadata.ofObject(propertyValue);
        }
        return BeanMetadata.ofClass(root.getBeanProperty(property).getType());
    }

    static Object getPropertyValue(Object root, BeanMetadata metadata, String propertyPath) {
        int signIndex = propertyPath.indexOf(91);
        if (signIndex < 0) {
            return metadata.getProperty(root, propertyPath);
        }
        return BeanPropertyAccessor.getKeyedPropertyValue(root, metadata, signIndex, propertyPath);
    }

    static Object getKeyedPropertyValue(Object root, BeanMetadata metadata, int signIndex, String propertyPath) {
        String property;
        int endIndex = propertyPath.indexOf(93);
        if (endIndex == -1 || signIndex + 1 == endIndex) {
            throw new IllegalArgumentException("Unsupported Operator: " + propertyPath);
        }
        Object propValue = root;
        if (signIndex != 0 && (propValue = metadata.getProperty(root, property = propertyPath.substring(0, signIndex))) == null) {
            return null;
        }
        try {
            String key = propertyPath.substring(signIndex + 1, endIndex);
            propValue = BeanPropertyAccessor.getKeyedPropertyValue(propValue, key);
            if (endIndex != propertyPath.length() - 1 && propertyPath.charAt(endIndex + 1) == '[') {
                return BeanPropertyAccessor.getKeyedPropertyValue(propValue, metadata, 0, propertyPath.substring(endIndex + 1));
            }
            return propValue;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Unsupported Operator: " + propertyPath + ", value: " + root, e);
        }
    }

    static Object getKeyedPropertyValue(Object propertyValue, String key) {
        if (propertyValue instanceof Map) {
            Map map = (Map)propertyValue;
            return map.get(key);
        }
        if (propertyValue instanceof List) {
            List list = (List)propertyValue;
            return list.get(Integer.parseInt(key));
        }
        if (propertyValue instanceof Set) {
            Set set = (Set)propertyValue;
            int index = Integer.parseInt(key);
            if (index < 0 || index >= set.size()) {
                throw new IndexOutOfBoundsException("Cannot get element with index " + index + " from Set of size " + set.size());
            }
            Iterator it = set.iterator();
            int j = 0;
            while (it.hasNext()) {
                Object elem = it.next();
                if (j == index) {
                    return elem;
                }
                ++j;
            }
        } else if (propertyValue.getClass().isArray()) {
            int length;
            int arrayIndex = Integer.parseInt(key);
            if (arrayIndex >= (length = Array.getLength(propertyValue))) {
                throw new ArrayIndexOutOfBoundsException(length);
            }
            return Array.get(propertyValue, arrayIndex);
        }
        throw new IllegalArgumentException("Unsupported data structure: " + propertyValue.getClass() + ", value: " + propertyValue);
    }

    public void setProperty(String propertyPath, Object value) {
        this.setProperty(this.getRootObject(), this.obtainMetadata(), propertyPath, value);
    }

    public void setProperty(Object root, String propertyPath, Object value) {
        this.setProperty(root, BeanMetadata.ofObject(root), propertyPath, value);
    }

    public void setProperty(Object root, BeanMetadata metadata, String propertyPath, Object value) {
        int index = BeanPropertyAccessor.getNestedPropertySeparatorIndex(propertyPath);
        if (index != -1) {
            Object subValue;
            Class<?> propertyType;
            if (propertyPath.charAt(index - 1) == ']') {
                Class<?> componentType;
                BeanProperty beanProperty;
                int signIndex;
                block14: {
                    signIndex = propertyPath.indexOf(91);
                    beanProperty = this.getBeanProperty(metadata, propertyPath, signIndex);
                    if (beanProperty == null) {
                        return;
                    }
                    componentType = beanProperty.getComponentClass();
                    propertyType = componentType != null ? componentType : root.getClass();
                    try {
                        subValue = BeanPropertyAccessor.getProperty(root, metadata, propertyPath.substring(0, index));
                    }
                    catch (IndexOutOfBoundsException ignored) {
                        subValue = this.getSubValue(root, beanProperty);
                        if (componentType == null) break block14;
                        subValue = this.getComponentValue(root, propertyPath, subValue, signIndex, beanProperty);
                    }
                }
                if (subValue == null) {
                    subValue = this.setNewValue(root, beanProperty);
                    if (componentType != null) {
                        subValue = this.getComponentValue(root, propertyPath, subValue, signIndex, beanProperty);
                    }
                }
            } else {
                BeanProperty beanProperty = this.getBeanProperty(metadata, propertyPath, index);
                if (beanProperty == null) {
                    return;
                }
                propertyType = beanProperty.getType();
                subValue = this.getSubValue(root, beanProperty);
            }
            BeanMetadata subMetadata = BeanMetadata.ofClass(propertyType);
            String newPath = propertyPath.substring(index + 1);
            this.setProperty(subValue, subMetadata, newPath, value);
        } else {
            int signIndex = propertyPath.indexOf(91);
            if (signIndex < 0) {
                BeanProperty beanProperty = this.getBeanProperty(metadata, propertyPath);
                if (beanProperty != null) {
                    this.setValue(root, beanProperty, value);
                }
            } else {
                BeanProperty beanProperty = this.getBeanProperty(metadata, propertyPath, signIndex);
                if (beanProperty != null) {
                    Object subValue = this.getSubValue(root, beanProperty);
                    String key = BeanPropertyAccessor.getKey(propertyPath, signIndex);
                    this.setKeyedProperty(root, beanProperty, subValue, key, value, propertyPath);
                }
            }
        }
    }

    private void setValue(Object root, BeanProperty beanProperty, Object value) {
        if (beanProperty.isReadOnly()) {
            if (this.throwsWhenReadOnly) {
                throw new PropertyReadOnlyException(root + " has a property: '" + beanProperty.getName() + "' that is read-only");
            }
        } else {
            beanProperty.setDirectly(root, this.convertIfNecessary(value, beanProperty));
        }
    }

    private BeanProperty getBeanProperty(BeanMetadata metadata, String propertyPath, int index) {
        String property = propertyPath.substring(0, index);
        return this.getBeanProperty(metadata, property);
    }

    private BeanProperty getBeanProperty(BeanMetadata metadata, String propertyPath) {
        BeanProperty beanProperty = metadata.getBeanProperty(propertyPath);
        if (beanProperty == null && !this.ignoreUnknownProperty) {
            throw new NoSuchPropertyException(metadata.getType(), propertyPath);
        }
        return beanProperty;
    }

    protected Object getComponentValue(Object root, String propertyPath, Object subValue, int signIndex, BeanProperty beanProperty) {
        Object componentValue = beanProperty.newComponentInstance();
        String key = BeanPropertyAccessor.getKey(propertyPath, signIndex);
        this.setKeyedProperty(root, beanProperty, subValue, key, componentValue, propertyPath);
        return componentValue;
    }

    protected static String getKey(String propertyPath, int signIndex) {
        return propertyPath.substring(signIndex + 1, propertyPath.indexOf(93));
    }

    private Object setNewValue(Object root, BeanProperty beanProperty) {
        Object subValue = beanProperty.newInstance();
        this.setValue(root, beanProperty, subValue);
        return subValue;
    }

    private Object getSubValue(Object object, BeanProperty beanProperty) {
        Object subValue = beanProperty.getValue(object);
        if (subValue == null) {
            subValue = this.setNewValue(object, beanProperty);
        }
        return subValue;
    }

    protected void setKeyedProperty(Object root, BeanProperty beanProperty, Object propValue, String key, Object value, String propertyPath) {
        if (propValue instanceof List) {
            Object convertedValue = value;
            Type valueType = beanProperty.getGeneric(0);
            if (valueType instanceof Class) {
                convertedValue = this.convertIfNecessary(convertedValue, (Class)valueType);
            }
            List list = (List)propValue;
            int index = Integer.parseInt(key);
            try {
                CollectionUtils.setValue(list, index, convertedValue);
            }
            catch (NullPointerException ex) {
                throw new InvalidPropertyValueException("Cannot set element with index " + index + " in List of size " + list.size() + ", accessed using property path '" + propertyPath + "': List does not support filling up gaps with null elements");
            }
            catch (IndexOutOfBoundsException ex) {
                throw new InvalidPropertyValueException("Invalid list index in property path '" + propertyPath + "'", ex);
            }
        } else if (propValue instanceof Map) {
            Type valueType;
            Object convertedKey = key;
            Object convertedValue = value;
            Type keyType = beanProperty.getGeneric(0);
            if (keyType instanceof Class) {
                convertedKey = this.convertIfNecessary(convertedKey, (Class)keyType);
            }
            if ((valueType = beanProperty.getGeneric(1)) instanceof Class) {
                convertedValue = this.convertIfNecessary(convertedValue, (Class)valueType);
            }
            ((Map)propValue).put(convertedKey, convertedValue);
        } else {
            Class<?> propValueClass = propValue.getClass();
            if (propValueClass.isArray()) {
                int length;
                Class<?> componentType = propValueClass.getComponentType();
                int arrayIndex = Integer.parseInt(key);
                if (arrayIndex >= (length = Array.getLength(propValue)) && arrayIndex < Integer.MAX_VALUE) {
                    Object newArray = Array.newInstance(componentType, arrayIndex + 1);
                    System.arraycopy(propValue, 0, newArray, 0, length);
                    propValue = newArray;
                    this.setValue(root, beanProperty, propValue);
                }
                Array.set(propValue, arrayIndex, this.convertIfNecessary(value, componentType));
            } else {
                throw new InvalidPropertyValueException("Property referenced in indexed property path '" + propertyPath + "' is neither an array nor a List nor a Map; returned value was [" + propValue + "]");
            }
        }
    }

    protected Object convertIfNecessary(Object value, BeanProperty beanProperty) {
        if (value == null || beanProperty.isInstance(value)) {
            return value;
        }
        return this.doConvertInternal(value, beanProperty);
    }

    protected Object doConvertInternal(Object value, BeanProperty beanProperty) {
        return this.doConvertInternal(value, GenericDescriptor.ofProperty(beanProperty));
    }

    protected Object convertIfNecessary(Object value, Class<?> requiredType) {
        if (value == null || requiredType.isInstance(value)) {
            return value;
        }
        return this.doConvertInternal(value, GenericDescriptor.valueOf(requiredType));
    }

    protected Object doConvertInternal(Object value, GenericDescriptor requiredType) {
        TypeConverter typeConverter = this.getConversionService().getConverter(value, requiredType);
        if (typeConverter == null) {
            return this.converterNotFound(value, requiredType);
        }
        return typeConverter.convert(requiredType, value);
    }

    protected Object converterNotFound(Object value, GenericDescriptor requiredType) {
        throw new InvalidPropertyValueException("Invalid property value [" + value + "] cannot convert '" + value.getClass() + "' to target class: [" + requiredType + "]");
    }

    public static int getNestedPropertySeparatorIndex(String propertyPath) {
        int idx = 0;
        boolean inKey = false;
        for (char value : propertyPath.toCharArray()) {
            if (value == '[' || value == ']') {
                inKey = !inKey;
            } else if (value == '.' && !inKey) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public void setRootObject(Object rootObject) {
        this.rootObject = rootObject;
    }

    public void setMetadata(BeanMetadata metadata) {
        this.metadata = metadata;
    }

    public Object getRootObject() {
        if (this.rootObject == null) {
            this.setRootObject(this.obtainMetadata().newInstance());
        }
        return this.rootObject;
    }

    public BeanMetadata getMetadata() {
        return this.metadata;
    }

    public BeanMetadata obtainMetadata() {
        BeanMetadata metadata = this.getMetadata();
        Assert.state(metadata != null, "No BeanMetadata.");
        return metadata;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        ConversionService conversionService = this.conversionService;
        if (conversionService == null) {
            this.conversionService = conversionService = DefaultConversionService.getSharedInstance();
        }
        return conversionService;
    }

    public void setIgnoreUnknownProperty(boolean ignoreUnknownProperty) {
        this.ignoreUnknownProperty = ignoreUnknownProperty;
    }

    public boolean isIgnoreUnknownProperty() {
        return this.ignoreUnknownProperty;
    }

    public void setThrowsWhenReadOnly(boolean throwsWhenReadOnly) {
        this.throwsWhenReadOnly = throwsWhenReadOnly;
    }

    public boolean isThrowsWhenReadOnly() {
        return this.throwsWhenReadOnly;
    }

    public static BeanPropertyAccessor ofObject(Object object) {
        return new BeanPropertyAccessor(object);
    }

    public static BeanPropertyAccessor ofClass(Class<?> beanClass) {
        return new BeanPropertyAccessor(beanClass);
    }

    public static BeanPropertyAccessor of(BeanMetadata metadata, Object object) {
        return new BeanPropertyAccessor(metadata, object);
    }
}

