/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.factory.BeanMetadata;
import cn.taketoday.context.factory.BeanProperty;
import cn.taketoday.context.factory.BeanPropertyAccessor;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ObjectUtils;
import java.util.Map;

public class BeanProperties {
    public static void copy(Object source, Object destination) {
        Assert.notNull(source, "source object must not be null");
        Assert.notNull(destination, "destination object must not be null");
        BeanMetadata destinationMetadata = BeanMetadata.ofObject(destination);
        BeanProperties.copy(source, destinationMetadata, destination, null);
    }

    public static void copy(Object source, Object destination, String ... ignoreProperties) {
        Assert.notNull(source, "source object must not be null");
        Assert.notNull(destination, "destination object must not be null");
        BeanMetadata destinationMetadata = BeanMetadata.ofObject(destination);
        BeanProperties.copy(source, destinationMetadata, destination, ignoreProperties);
    }

    public static <T> T copy(Object source, Class<T> destination) {
        Assert.notNull(source, "source object must not be null");
        Assert.notNull(destination, "destination class must not be null");
        BeanMetadata destinationMetadata = BeanMetadata.ofClass(destination);
        Object destinationInstance = destinationMetadata.newInstance();
        BeanProperties.copy(source, destinationMetadata, destinationInstance, null);
        return (T)destinationInstance;
    }

    public static <T> T copy(Object source, Class<T> destination, String ... ignoreProperties) {
        Assert.notNull(source, "source object must not be null");
        Assert.notNull(destination, "destination class must not be null");
        BeanMetadata destinationMetadata = BeanMetadata.ofClass(destination);
        Object destinationInstance = destinationMetadata.newInstance();
        BeanProperties.copy(source, destinationMetadata, destinationInstance, ignoreProperties);
        return (T)destinationInstance;
    }

    private static void copy(Object source, BeanMetadata destinationMetadata, Object destinationInstance, String[] ignoreProperties) {
        if (source instanceof Map) {
            for (Map.Entry entry : ((Map)source).entrySet()) {
                BeanProperty beanProperty;
                String propertyName = (String)entry.getKey();
                if (!BeanProperties.allowCopy(ignoreProperties, propertyName) || (beanProperty = destinationMetadata.getBeanProperty(propertyName)) == null || beanProperty.isReadOnly()) continue;
                Object value = entry.getValue();
                beanProperty.setValue(destinationInstance, value);
            }
        } else {
            BeanMetadata sourceMetadata = BeanMetadata.ofObject(source);
            for (Map.Entry<String, BeanProperty> entry : sourceMetadata.getBeanProperties().entrySet()) {
                BeanProperty beanProperty;
                String propertyName = entry.getKey();
                if (!BeanProperties.allowCopy(ignoreProperties, propertyName) || (beanProperty = destinationMetadata.getBeanProperty(propertyName)) == null || beanProperty.isReadOnly()) continue;
                Object value = entry.getValue().getValue(source);
                beanProperty.setValue(destinationInstance, value);
            }
        }
    }

    private static boolean allowCopy(String[] ignoreProperties, String propertyName) {
        if (ObjectUtils.isNotEmpty(ignoreProperties)) {
            for (String ignoreProperty : ignoreProperties) {
                if (!propertyName.equals(ignoreProperty)) continue;
                return false;
            }
        }
        return true;
    }

    public static void populate(Object bean, Map<String, Object> properties) {
        BeanProperties.populate(bean, properties, true);
    }

    public static void populate(Object bean, Map<String, Object> properties, boolean ignoreUnknownProperty) {
        Assert.notNull(bean, "target bean must not be null");
        Assert.notNull(properties, "properties must not be null");
        BeanPropertyAccessor accessor = new BeanPropertyAccessor(bean);
        accessor.setIgnoreUnknownProperty(ignoreUnknownProperty);
        accessor.setThrowsWhenReadOnly(false);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            accessor.setProperty(key, value);
        }
    }
}

