/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.factory.BeanMetadata;
import cn.taketoday.context.factory.BeanProperty;
import cn.taketoday.context.factory.PropertyReadOnlyException;
import cn.taketoday.context.utils.Assert;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class BeanMapping<T>
extends AbstractMap<String, Object>
implements Map<String, Object> {
    private T target;
    private final BeanMetadata metadata;
    private boolean ignoreReadOnly;

    public BeanMapping(T target) {
        this.target = target;
        this.metadata = BeanMetadata.ofObject(target);
    }

    public BeanMapping(BeanMetadata metadata) {
        this.metadata = metadata;
    }

    BeanMapping(T target, BeanMetadata metadata) {
        this.target = target;
        this.metadata = metadata;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        Object target = this.obtainTarget();
        LinkedHashSet<Map.Entry<String, Object>> entrySet = new LinkedHashSet<Map.Entry<String, Object>>();
        for (Map.Entry<String, BeanProperty> entry : this.metadata.getBeanProperties().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue().getValue(target);
            entrySet.add(new Node<String, Object>(key, value));
        }
        return entrySet;
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.metadata.getBeanProperties().keySet());
    }

    @Override
    public final Object get(Object key) {
        if (key instanceof String) {
            return this.get(this.obtainTarget(), (String)key);
        }
        throw new IllegalArgumentException("key must be a string");
    }

    public Object get(Object target, String key) {
        return this.metadata.getProperty(target, key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.put(this.obtainTarget(), key, value);
    }

    public Object put(Object target, String key, Object value) {
        BeanProperty beanProperty = this.metadata.obtainBeanProperty(key);
        if (beanProperty.isReadOnly()) {
            if (!this.ignoreReadOnly) {
                throw new PropertyReadOnlyException(target + " has a property: '" + beanProperty.getName() + "' that is read-only");
            }
        } else {
            Object property = beanProperty.getValue(target);
            beanProperty.setValue(target, value);
            return property;
        }
        return beanProperty.getValue(target);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (o != this) {
            if (!(o instanceof Map)) {
                return false;
            }
            Map other = (Map)o;
            if (this.size() != other.size()) {
                return false;
            }
            for (String key : this.keySet()) {
                if (Objects.equals(this.get(key), other.get(key))) continue;
                return false;
            }
        }
        return true;
    }

    public Object getTarget() {
        return this.target;
    }

    private Object obtainTarget() {
        Object target = this.getTarget();
        Assert.state(target != null, "No target");
        return target;
    }

    public void setTarget(T target) {
        this.target = target;
    }

    public Class<?> getPropertyType(String name) {
        BeanProperty beanProperty = this.metadata.getBeanProperty(name);
        if (beanProperty != null) {
            return beanProperty.getType();
        }
        return null;
    }

    public BeanMapping<T> newInstance(T bean) {
        return new BeanMapping<T>(bean, this.metadata);
    }

    public T newInstance() {
        Object instance = this.metadata.newInstance();
        this.setTarget(instance);
        return (T)instance;
    }

    public void setIgnoreReadOnly(boolean ignoreReadOnly) {
        this.ignoreReadOnly = ignoreReadOnly;
    }

    public boolean isIgnoreReadOnly() {
        return this.ignoreReadOnly;
    }

    public static <T> BeanMapping<T> ofObject(T bean) {
        return new BeanMapping<T>(bean);
    }

    public static <T> BeanMapping<T> ofClass(Class<T> beanClass) {
        BeanMetadata metadata = BeanMetadata.ofClass(beanClass);
        return new BeanMapping<Object>(metadata.newInstance(), metadata);
    }

    static final class Node<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V value;

        Node(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }

        @Override
        public final int hashCode() {
            return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Map.Entry e;
            if (o == this) {
                return true;
            }
            return o instanceof Map.Entry && Objects.equals(this.key, (e = (Map.Entry)o).getKey()) && Objects.equals(this.value, e.getValue());
        }
    }
}

