/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.context.factory.AbstractBeanFactory;
import cn.taketoday.context.factory.PropertySetter;
import cn.taketoday.context.reflect.SetterMethod;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.Objects;

public abstract class AbstractPropertySetter
implements PropertySetter {
    protected final Field field;
    protected final SetterMethod accessor;

    public AbstractPropertySetter(Field field) {
        Assert.notNull((Object)field, "field must not be null");
        this.field = field;
        this.accessor = ReflectionUtils.newSetterMethod(field);
    }

    @Override
    public void applyValue(Object bean, AbstractBeanFactory beanFactory) {
        Object property = this.resolveValue(beanFactory);
        if (property != DO_NOT_SET) {
            this.doSetValue(bean, property);
        }
    }

    public void doSetValue(Object bean, Object value) {
        this.accessor.set(bean, value);
    }

    protected abstract Object resolveValue(AbstractBeanFactory var1);

    @Override
    public String getName() {
        return this.field.getName();
    }

    public Field getField() {
        return this.field;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractPropertySetter)) {
            return false;
        }
        AbstractPropertySetter that = (AbstractPropertySetter)o;
        return Objects.equals(this.field, that.field);
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public String toString() {
        return "{\"property\":\"" + this.field.getName() + "\",\"propertyClass\":\"" + this.field.getType() + "\",\"beanClass:\":\"" + this.field.getDeclaringClass() + "\"}";
    }
}

