/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.factory;

import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.proxy.ProxyFactory;
import cn.taketoday.context.BeanNameCreator;
import cn.taketoday.context.Scope;
import cn.taketoday.context.annotation.Primary;
import cn.taketoday.context.aware.Aware;
import cn.taketoday.context.aware.BeanClassLoaderAware;
import cn.taketoday.context.aware.BeanFactoryAware;
import cn.taketoday.context.aware.BeanNameAware;
import cn.taketoday.context.env.DefaultBeanNameCreator;
import cn.taketoday.context.exception.BeanInitializingException;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.exception.NoSuchBeanDefinitionException;
import cn.taketoday.context.factory.AbstractFactoryBean;
import cn.taketoday.context.factory.AutowireCapableBeanFactory;
import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.factory.BeanPostProcessor;
import cn.taketoday.context.factory.BeanReferencePropertySetter;
import cn.taketoday.context.factory.BeansException;
import cn.taketoday.context.factory.ConfigurableBeanFactory;
import cn.taketoday.context.factory.DefaultBeanDefinition;
import cn.taketoday.context.factory.DefaultObjectSupplier;
import cn.taketoday.context.factory.FactoryBean;
import cn.taketoday.context.factory.FactoryBeanDefinition;
import cn.taketoday.context.factory.InitializingBean;
import cn.taketoday.context.factory.InstantiationAwareBeanPostProcessor;
import cn.taketoday.context.factory.ObjectFactory;
import cn.taketoday.context.factory.ObjectSupplier;
import cn.taketoday.context.factory.PropertySetter;
import cn.taketoday.context.factory.SmartFactoryBean;
import cn.taketoday.context.factory.SmartInitializingSingleton;
import cn.taketoday.context.loader.BeanDefinitionLoader;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.CollectionUtils;
import cn.taketoday.context.utils.ContextUtils;
import cn.taketoday.context.utils.ObjectUtils;
import cn.taketoday.context.utils.OrderUtils;
import cn.taketoday.context.utils.ReflectionUtils;
import cn.taketoday.context.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractBeanFactory
implements ConfigurableBeanFactory,
AutowireCapableBeanFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractBeanFactory.class);
    private BeanNameCreator beanNameCreator;
    private Map<Class<?>, Object> objectFactories;
    private final HashSet<BeanReferencePropertySetter> dependencies = new HashSet(128);
    private final ArrayList<BeanPostProcessor> postProcessors = new ArrayList();
    private final HashMap<String, Object> singletons = new HashMap(128);
    private final HashMap<String, Scope> scopes = new HashMap();
    private final ConcurrentHashMap<String, BeanDefinition> beanDefinitionMap = new ConcurrentHashMap(64);
    private boolean fullPrototype = false;
    private boolean fullLifecycle = false;
    private boolean hasInstantiationAwareBeanPostProcessors;

    @Override
    public Object getBean(String name) {
        BeanDefinition def = this.getBeanDefinition(name);
        return def != null ? this.getBean(def) : this.getSingleton(name);
    }

    @Override
    public Object getBean(BeanDefinition def) {
        if (def.isFactoryBean()) {
            return this.getFactoryBean(def).getBean();
        }
        if (def.isInitialized()) {
            return this.getSingleton(def.getName());
        }
        BeanDefinition child = def.getChild();
        if (child == null) {
            if (def.isSingleton()) {
                return this.createSingleton(def);
            }
            if (def.isPrototype()) {
                return this.createPrototype(def);
            }
            Scope scope = this.scopes.get(def.getScope());
            if (scope == null) {
                throw new ConfigurationException("No such scope: [" + def.getScope() + "] in this " + this);
            }
            return this.getScopeBean(def, scope);
        }
        if (def.isPrototype()) {
            return this.createPrototype(child);
        }
        Object bean = this.initializeSingleton(this.getSingleton(def.getName()), child);
        if (!def.isInitialized()) {
            this.registerSingleton(def.getName(), bean);
            def.setInitialized(true);
        }
        return bean;
    }

    @Override
    public <T> T getBean(Class<T> requiredType) {
        Object bean = this.getBean(this.getBeanNameCreator().create(requiredType));
        return (T)(requiredType.isInstance(bean) ? bean : this.doGetBeanForType(requiredType));
    }

    protected <T> Object doGetBeanForType(Class<T> requiredType) {
        for (Map.Entry<String, BeanDefinition> entry : this.getBeanDefinitions().entrySet()) {
            Object bean;
            if (!requiredType.isAssignableFrom(entry.getValue().getBeanClass()) || (bean = this.getBean(entry.getValue())) == null) continue;
            return bean;
        }
        for (Object object : this.getSingletons().values()) {
            if (!requiredType.isAssignableFrom(object.getClass())) continue;
            return object;
        }
        return null;
    }

    @Override
    public <T> T getBean(String name, Class<T> requiredType) {
        Object bean = this.getBean(name);
        return (T)(requiredType.isInstance(bean) ? bean : null);
    }

    @Override
    public <T> ObjectSupplier<T> getBeanSupplier(final BeanDefinition def) {
        Assert.notNull((Object)def, "BeanDefinition must not be null");
        if (def.isSingleton()) {
            final class SingletonObjectSupplier
            implements ObjectSupplier<T> {
                T targetSingleton;

                SingletonObjectSupplier() {
                }

                @Override
                public T getIfAvailable() throws BeansException {
                    Object ret = this.targetSingleton;
                    if (ret == null) {
                        ret = this.targetSingleton = AbstractBeanFactory.this.getBean(def);
                    }
                    return ret;
                }

                @Override
                public T get() {
                    return this.getIfAvailable();
                }

                @Override
                public Stream<T> orderedStream() {
                    return this.stream();
                }

                @Override
                public Stream<T> stream() {
                    return Stream.of(this.targetSingleton);
                }
            }
            return new SingletonObjectSupplier();
        }
        return new DefaultObjectSupplier<T>(def.getBeanClass(), this){

            @Override
            public T getIfAvailable() throws BeansException {
                return AbstractBeanFactory.this.getBean(def);
            }
        };
    }

    @Override
    public <T> ObjectSupplier<T> getBeanSupplier(Class<T> requiredType) {
        Assert.notNull(requiredType, "requiredType must not be null");
        return new DefaultObjectSupplier(requiredType, this);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(Class<T> requiredType, boolean includeNonSingletons) {
        return this.getBeansOfType(requiredType, true, includeNonSingletons);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(Class<T> requiredType, boolean includeNoneRegistered, boolean includeNonSingletons) {
        HashMap<String, Object> beans = new HashMap<String, Object>();
        for (Map.Entry<String, BeanDefinition> entry : this.getBeanDefinitions().entrySet()) {
            Object bean;
            BeanDefinition def = entry.getValue();
            if (!AbstractBeanFactory.isEligibleBean(def, requiredType, includeNonSingletons) || (bean = this.getBean(def)) == null) continue;
            beans.put(entry.getKey(), bean);
        }
        if (includeNoneRegistered) {
            for (Map.Entry<String, Object> entry : this.getSingletons().entrySet()) {
                Object bean = entry.getValue();
                if (beans.containsKey(entry.getKey()) || requiredType != null && !requiredType.isInstance(bean)) continue;
                beans.put(entry.getKey(), bean);
            }
        }
        return beans;
    }

    @Override
    public Set<String> getBeanNamesOfType(Class<?> requiredType, boolean includeNonSingletons) {
        return this.getBeanNamesOfType(requiredType, true, includeNonSingletons);
    }

    @Override
    public Set<String> getBeanNamesOfType(Class<?> requiredType, boolean includeNoneRegistered, boolean includeNonSingletons) {
        LinkedHashSet<String> beanNames = new LinkedHashSet<String>();
        for (Map.Entry<String, BeanDefinition> entry : this.getBeanDefinitions().entrySet()) {
            BeanDefinition def = entry.getValue();
            if (!AbstractBeanFactory.isEligibleBean(def, requiredType, includeNonSingletons)) continue;
            beanNames.add(entry.getKey());
        }
        if (includeNoneRegistered) {
            for (Map.Entry<String, Object> entry : this.getSingletons().entrySet()) {
                Object bean = entry.getValue();
                if (requiredType != null && !requiredType.isInstance(bean)) continue;
                beanNames.add(entry.getKey());
            }
        }
        return beanNames;
    }

    static boolean isEligibleBean(BeanDefinition def, Class<?> requiredType, boolean includeNonSingletons) {
        return !(!includeNonSingletons && !def.isSingleton() || requiredType != null && !requiredType.isAssignableFrom(def.getBeanClass()));
    }

    @Override
    public Map<String, Object> getBeansOfAnnotation(Class<? extends Annotation> annotationType, boolean includeNonSingletons) {
        Assert.notNull(annotationType, "annotationType must not be null");
        HashMap<String, Object> beans = new HashMap<String, Object>();
        for (Map.Entry<String, BeanDefinition> entry : this.getBeanDefinitions().entrySet()) {
            Object bean;
            BeanDefinition def = entry.getValue();
            if (!includeNonSingletons && !def.isSingleton() || !def.isAnnotationPresent(annotationType) || (bean = this.getBean(def)) == null) continue;
            beans.put(entry.getKey(), bean);
        }
        return beans;
    }

    @Override
    public <A extends Annotation> A getAnnotationOnBean(String beanName, Class<A> annotationType) {
        return this.obtainBeanDefinition(beanName).getAnnotation(annotationType);
    }

    @Override
    public Map<String, BeanDefinition> getBeanDefinitions() {
        return this.beanDefinitionMap;
    }

    protected Object createBeanIfNecessary(BeanDefinition def) {
        if (def.isSingleton()) {
            String name = def.getName();
            Object bean = this.getSingleton(name);
            if (bean == null) {
                bean = this.createBeanInstance(def);
                this.registerSingleton(name, bean);
            }
            return bean;
        }
        return this.createBeanInstance(def);
    }

    protected Object createBeanInstance(BeanDefinition def) {
        if (this.hasInstantiationAwareBeanPostProcessors) {
            for (BeanPostProcessor processor : this.getPostProcessors()) {
                Object bean;
                if (!(processor instanceof InstantiationAwareBeanPostProcessor) || (bean = ((InstantiationAwareBeanPostProcessor)processor).postProcessBeforeInstantiation(def)) == null) continue;
                return bean;
            }
        }
        return def.newInstance(this);
    }

    protected void applyPropertyValues(Object bean, BeanDefinition def) {
        for (PropertySetter propertySetter : def.getPropertySetters()) {
            propertySetter.applyValue(bean, this);
        }
    }

    protected void invokeInitMethods(Object bean, BeanDefinition def) {
        if (def instanceof DefaultBeanDefinition) {
            ((DefaultBeanDefinition)def).fastInvokeInitMethods(bean, this);
        } else {
            for (Method method : def.getInitMethods()) {
                try {
                    ReflectionUtils.makeAccessible(method);
                    Object[] args = ContextUtils.resolveParameter(method, this);
                    method.invoke(bean, args);
                }
                catch (Exception e) {
                    throw new BeanInitializingException("An Exception Occurred When [" + bean + "] invoke init method: [" + method + "]", e);
                }
            }
        }
        if (bean instanceof InitializingBean) {
            try {
                ((InitializingBean)bean).afterPropertiesSet();
            }
            catch (Exception e) {
                throw new BeanInitializingException("An Exception Occurred When [" + bean + "] apply after properties", e);
            }
        }
    }

    protected Object createPrototype(BeanDefinition def) {
        return this.initializeBean(this.createBeanInstance(def), def);
    }

    protected <T> FactoryBean<T> getFactoryBean(BeanDefinition def) {
        FactoryBean<T> factoryBean = this.getFactoryBeanInstance(def);
        if (def.isInitialized()) {
            return factoryBean;
        }
        if (factoryBean instanceof AbstractFactoryBean) {
            ((AbstractFactoryBean)factoryBean).setSingleton(def.isSingleton());
        }
        if (log.isDebugEnabled()) {
            log.debug("Initialize FactoryBean: [{}]", (Object)def.getName());
        }
        Object initBean = this.initializeBean(factoryBean, def);
        def.setInitialized(true);
        this.registerSingleton(this.getFactoryBeanName(def), initBean);
        return (FactoryBean)initBean;
    }

    protected <T> FactoryBean<T> getFactoryBeanInstance(BeanDefinition def) {
        if (def instanceof FactoryBeanDefinition) {
            return ((FactoryBeanDefinition)def).getFactory();
        }
        Object factory = this.getSingleton(this.getFactoryBeanName(def));
        if (factory instanceof FactoryBean) {
            return (FactoryBean)factory;
        }
        factory = this.createBeanInstance(def);
        if (factory instanceof FactoryBean) {
            return (FactoryBean)factory;
        }
        throw new ConfigurationException("object must be FactoryBean");
    }

    protected String getFactoryBeanName(BeanDefinition def) {
        return "$".concat(def.getName());
    }

    @Override
    public Object getScopeBean(BeanDefinition def, Scope scope) {
        return scope.get(def, this::createPrototype);
    }

    @Override
    public Object initializeBean(Object bean, BeanDefinition def) {
        if (log.isDebugEnabled()) {
            log.debug("Initializing bean named: [{}].", (Object)def.getName());
        }
        this.aware(bean, def);
        List<BeanPostProcessor> postProcessors = this.getPostProcessors();
        if (postProcessors.isEmpty()) {
            this.applyPropertyValues(bean, def);
            this.invokeInitMethods(bean, def);
            return bean;
        }
        return this.initWithPostProcessors(bean, def, postProcessors);
    }

    protected Object initWithPostProcessors(Object bean, BeanDefinition def, List<BeanPostProcessor> processors) {
        Object ret = bean;
        for (BeanPostProcessor processor : processors) {
            try {
                ret = processor.postProcessBeforeInitialization(ret, def);
            }
            catch (Exception e) {
                throw new BeanInitializingException("An Exception Occurred When [" + bean + "] before properties set", e);
            }
        }
        this.applyPropertyValues(ret, def);
        this.invokeInitMethods(ret, def);
        for (BeanPostProcessor processor : processors) {
            try {
                ret = processor.postProcessAfterInitialization(ret, def);
            }
            catch (Exception e) {
                throw new BeanInitializingException("An Exception Occurred When [" + bean + "] after properties set", e);
            }
        }
        return ret;
    }

    public final void aware(Object bean, BeanDefinition def) {
        if (bean instanceof Aware) {
            this.awareInternal(bean, def);
        }
    }

    protected void awareInternal(Object bean, BeanDefinition def) {
        if (bean instanceof BeanNameAware) {
            ((BeanNameAware)bean).setBeanName(def.getName());
        }
        if (bean instanceof BeanFactoryAware) {
            ((BeanFactoryAware)bean).setBeanFactory(this);
        }
        if (bean instanceof BeanClassLoaderAware) {
            ((BeanClassLoaderAware)bean).setBeanClassLoader(bean.getClass().getClassLoader());
        }
    }

    protected Object initializeSingleton(Object bean, BeanDefinition def) {
        if (bean == null) {
            return this.createSingleton(def);
        }
        Assert.isTrue(def.isSingleton(), "Bean definition must be a singleton");
        if (def.isInitialized()) {
            return bean;
        }
        Object afterInit = this.initializeBean(bean, def);
        if (afterInit != bean) {
            this.registerSingleton(def.getName(), afterInit);
        }
        def.setInitialized(true);
        return afterInit;
    }

    protected Object createSingleton(BeanDefinition def) {
        Assert.isTrue(def.isSingleton(), "Bean definition must be a singleton");
        if (def.isFactoryBean()) {
            Object bean = this.getFactoryBean(def).getBean();
            if (!this.containsSingleton(def.getName())) {
                this.registerSingleton(def.getName(), bean);
                def.setInitialized(true);
            }
            return bean;
        }
        if (def.isInitialized()) {
            return this.getSingleton(def.getName());
        }
        Object bean = this.createBeanIfNecessary(def);
        Object afterInit = this.initializeBean(bean, def);
        if (afterInit != bean) {
            this.registerSingleton(def.getName(), afterInit);
        }
        def.setInitialized(true);
        return afterInit;
    }

    public void registerBeanPostProcessors() {
        log.info("Loading BeanPostProcessor.");
        this.postProcessors.addAll(this.getBeans(BeanPostProcessor.class));
        OrderUtils.reversedSort(this.postProcessors);
    }

    public void handleDependency() {
        for (BeanReferencePropertySetter reference : this.getDependencies()) {
            String beanName = reference.getReferenceName();
            if (this.containsBeanDefinition(beanName)) {
                reference.setReference(this.getBeanDefinition(beanName));
                continue;
            }
            BeanDefinition handleDef = this.handleDependency(reference);
            if (handleDef != null) {
                this.registerBeanDefinition(beanName, handleDef);
                reference.setReference(handleDef);
                continue;
            }
            Class<?> propertyType = reference.getReferenceClass();
            List<BeanDefinition> childDefs = this.doGetChildDefinition(beanName, propertyType);
            if (!CollectionUtils.isEmpty(childDefs)) {
                BeanDefinition childDef = this.getPrimaryBeanDefinition(childDefs);
                if (log.isDebugEnabled()) {
                    log.debug("Found The Implementation Of [{}] Bean: [{}].", (Object)beanName, (Object)childDef.getName());
                }
                DefaultBeanDefinition def = new DefaultBeanDefinition(beanName, childDef);
                this.registerBeanDefinition(beanName, def);
                reference.setReference(def);
                continue;
            }
            if (!reference.isRequired()) continue;
            throw new ConfigurationException("Context does not exist for this reference:[" + reference + "] of bean");
        }
    }

    protected BeanDefinition getPrimaryBeanDefinition(List<BeanDefinition> defs) {
        BeanDefinition target = null;
        if (defs.size() > 1) {
            OrderUtils.reversedSort(defs);
            for (BeanDefinition def : defs) {
                if (!def.isAnnotationPresent(Primary.class)) continue;
                target = def;
                break;
            }
        }
        if (target == null) {
            target = defs.get(0);
        }
        return target;
    }

    protected List<BeanDefinition> doGetChildDefinition(String beanName, Class<?> beanClass) {
        HashSet<BeanDefinition> ret = new HashSet<BeanDefinition>();
        for (Map.Entry<String, BeanDefinition> entry : this.getBeanDefinitions().entrySet()) {
            BeanDefinition childDef = entry.getValue();
            Class<?> clazz = childDef.getBeanClass();
            if (beanClass == clazz || !beanClass.isAssignableFrom(clazz) || beanName.equals(childDef.getName())) continue;
            ret.add(childDef);
        }
        return ret.isEmpty() ? null : new ArrayList(ret);
    }

    protected BeanDefinition handleDependency(BeanReferencePropertySetter ref) {
        Object objectFactory;
        Map<Class<?>, Object> objectFactories = this.getObjectFactories();
        if (!CollectionUtils.isEmpty(objectFactories) && (objectFactory = objectFactories.get(ref.getReferenceClass())) != null) {
            final class DependencyBeanDefinition
            extends DefaultBeanDefinition {
                public DependencyBeanDefinition(String name, Class<?> beanClass) {
                    super(name, beanClass);
                }

                @Override
                public Object newInstance(BeanFactory factory) {
                    return this.createDependencyInstance(this.getBeanClass(), objectFactory);
                }
            }
            return new DependencyBeanDefinition(ref.getName(), ref.getReferenceClass());
        }
        return null;
    }

    protected Object createDependencyInstance(Class<?> type, Object objectFactory) {
        if (type.isInstance(objectFactory)) {
            return objectFactory;
        }
        if (objectFactory instanceof ObjectFactory) {
            return this.createObjectFactoryDependencyProxy(type, (ObjectFactory)objectFactory);
        }
        return null;
    }

    protected Object createObjectFactoryDependencyProxy(Class<?> type, ObjectFactory<?> objectFactory) {
        ProxyFactory proxyFactory = this.createProxyFactory();
        proxyFactory.setTargetSource(new ObjectFactoryTargetSource(objectFactory, type));
        proxyFactory.setOpaque(true);
        return proxyFactory.getProxy(type.getClassLoader());
    }

    protected ProxyFactory createProxyFactory() {
        return new ProxyFactory();
    }

    public final Map<Class<?>, Object> getObjectFactories() {
        if (this.objectFactories == null) {
            this.objectFactories = this.createObjectFactories();
        }
        return this.objectFactories;
    }

    protected Map<Class<?>, Object> createObjectFactories() {
        return new HashMap();
    }

    public void setObjectFactories(Map<Class<?>, Object> objectFactories) {
        this.objectFactories = objectFactories;
    }

    @Override
    public boolean isSingleton(String name) {
        return this.obtainBeanDefinition(name).isSingleton();
    }

    public BeanDefinition obtainBeanDefinition(String name) {
        BeanDefinition def = this.getBeanDefinition(name);
        if (def == null) {
            throw new NoSuchBeanDefinitionException(name);
        }
        return def;
    }

    @Override
    public boolean isPrototype(String name) {
        return !this.isSingleton(name);
    }

    @Override
    public Class<?> getType(String name) {
        return this.obtainBeanDefinition(name).getBeanClass();
    }

    @Override
    public Set<String> getAliases(Class<?> type) {
        return this.getBeanDefinitions().entrySet().stream().filter(entry -> type.isAssignableFrom(((BeanDefinition)entry.getValue()).getBeanClass())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public void registerBean(Class<?> clazz) {
        this.registerBean(this.getBeanNameCreator().create(clazz), clazz);
    }

    @Override
    public void registerBean(Set<Class<?>> candidates) {
        BeanNameCreator nameCreator = this.getBeanNameCreator();
        for (Class<?> candidate : candidates) {
            this.registerBean(nameCreator.create(candidate), candidate);
        }
    }

    @Override
    public void registerBean(String name, Class<?> clazz) {
        this.getBeanDefinitionLoader().loadBeanDefinition(name, clazz);
    }

    @Override
    public void registerBean(String name, BeanDefinition beanDefinition) {
        this.getBeanDefinitionLoader().register(name, beanDefinition);
    }

    @Override
    public void registerBean(Object obj) {
        this.registerBean(this.getBeanNameCreator().create(obj.getClass()), obj);
    }

    @Override
    public void registerBean(String name, Object obj) {
        Assert.notNull(obj, "bean instance must not be null");
        String nameToUse = name;
        Class<?> beanClass = obj.getClass();
        if (StringUtils.isEmpty(nameToUse)) {
            nameToUse = this.getBeanNameCreator().create(beanClass);
        }
        this.getBeanDefinitionLoader().loadBeanDefinition(nameToUse, beanClass);
        BeanDefinition def = this.getBeanDefinition(name);
        if (def.isSingleton()) {
            this.registerSingleton(name, obj);
        }
    }

    @Override
    public void addBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        Assert.notNull((Object)beanPostProcessor, "BeanPostProcessor must not be null");
        List<BeanPostProcessor> postProcessors = this.getPostProcessors();
        postProcessors.remove(beanPostProcessor);
        postProcessors.add(beanPostProcessor);
        OrderUtils.reversedSort(postProcessors);
        if (beanPostProcessor instanceof InstantiationAwareBeanPostProcessor) {
            this.hasInstantiationAwareBeanPostProcessors = true;
        }
    }

    @Override
    public void removeBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        this.getPostProcessors().remove(beanPostProcessor);
        for (BeanPostProcessor postProcessor : this.getPostProcessors()) {
            if (!(postProcessor instanceof InstantiationAwareBeanPostProcessor)) continue;
            this.hasInstantiationAwareBeanPostProcessors = true;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSingleton(String name, Object singleton) {
        Assert.notNull((Object)name, "Bean name must not be null");
        Assert.notNull(singleton, "Singleton object must not be null");
        HashMap<String, Object> hashMap = this.singletons;
        synchronized (hashMap) {
            Object oldBean = this.singletons.put(name, singleton);
            if (oldBean == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Register Singleton: [{}] = [{}]", (Object)name, (Object)ObjectUtils.toHexString(singleton));
                }
            } else if (oldBean != singleton) {
                log.info("Refresh Singleton: [{}] = [{}] old bean: [{}] ", name, ObjectUtils.toHexString(singleton), ObjectUtils.toHexString(oldBean));
            }
        }
    }

    @Override
    public void registerSingleton(Object bean) {
        this.registerSingleton(this.getBeanNameCreator().create(bean.getClass()), bean);
    }

    @Override
    public Map<String, Object> getSingletons() {
        return this.singletons;
    }

    @Override
    public Object getSingleton(String name) {
        return this.singletons.get(name);
    }

    @Override
    public <T> T getSingleton(Class<T> requiredType) {
        String maybe = this.getBeanNameCreator().create(requiredType);
        Object singleton = this.getSingleton(maybe);
        if (singleton == null) {
            Map<String, Object> singletons = this.getSingletons();
            for (Object value : singletons.values()) {
                if (!requiredType.isInstance(value)) continue;
                return (T)value;
            }
        } else if (requiredType.isInstance(singleton)) {
            return (T)singleton;
        }
        return null;
    }

    @Override
    public void removeSingleton(String name) {
        this.singletons.remove(name);
    }

    @Override
    public void removeBean(String name) {
        this.removeBeanDefinition(name);
        this.removeSingleton(name);
    }

    @Override
    public boolean containsSingleton(String name) {
        return this.singletons.containsKey(name);
    }

    @Override
    public void registerBeanDefinition(String beanName, BeanDefinition def) {
        this.beanDefinitionMap.put(beanName, def);
        this.postProcessRegisterBeanDefinition(def);
    }

    protected void postProcessRegisterBeanDefinition(BeanDefinition targetDef) {
        Object[] propertySetters = targetDef.getPropertySetters();
        if (ObjectUtils.isNotEmpty(propertySetters)) {
            for (Object propertySetter : propertySetters) {
                if (!(propertySetter instanceof BeanReferencePropertySetter)) continue;
                this.dependencies.add((BeanReferencePropertySetter)propertySetter);
            }
        }
    }

    @Override
    public void registerScope(String name, Scope scope) {
        Assert.notNull((Object)name, "scope name must not be null");
        Assert.notNull((Object)scope, "scope object must not be null");
        this.scopes.put(name, scope);
    }

    @Override
    public void destroyBean(Object beanInstance, BeanDefinition def) {
        if (beanInstance == null || def == null) {
            return;
        }
        try {
            ContextUtils.destroyBean(beanInstance, def, this.getPostProcessors());
        }
        catch (Throwable e) {
            log.warn("An Exception Occurred When Destroy a bean: [{}], With Msg: [{}]", def.getName(), e.toString(), e);
        }
    }

    @Override
    public void destroyBean(String name) {
        this.destroyBean(name, this.getSingleton(name));
    }

    @Override
    public void destroyBean(String name, Object beanInstance) {
        String factoryBeanName;
        BeanDefinition def = this.getBeanDefinition(name);
        if (def == null && name.charAt(0) == '$' && (def = this.getBeanDefinition(factoryBeanName = name.substring(1))) != null) {
            this.destroyBean(this.getSingleton(factoryBeanName), def);
        }
        if (def == null) {
            def = this.getPrototypeBeanDefinition(ClassUtils.getUserClass(beanInstance));
        }
        this.destroyBean(beanInstance, def);
    }

    @Override
    public void destroyScopedBean(String beanName) {
        BeanDefinition def = this.obtainBeanDefinition(beanName);
        if (def.isSingleton() || def.isPrototype()) {
            throw new IllegalArgumentException("Bean name '" + beanName + "' does not correspond to an object in a mutable scope");
        }
        Scope scope = this.scopes.get(def.getScope());
        if (scope == null) {
            throw new IllegalStateException("No Scope SPI registered for scope name '" + def.getScope() + "'");
        }
        Object bean = scope.remove(beanName);
        if (bean != null) {
            this.destroyBean(bean, def);
        }
    }

    @Override
    public String getBeanName(Class<?> targetClass) {
        for (Map.Entry<String, BeanDefinition> entry : this.getBeanDefinitions().entrySet()) {
            if (entry.getValue().getBeanClass() != targetClass) continue;
            return entry.getKey();
        }
        throw new NoSuchBeanDefinitionException(targetClass);
    }

    @Override
    public void removeBeanDefinition(String beanName) {
        this.beanDefinitionMap.remove(beanName);
    }

    @Override
    public BeanDefinition getBeanDefinition(String beanName) {
        return this.beanDefinitionMap.get(beanName);
    }

    @Override
    public BeanDefinition getBeanDefinition(Class<?> beanClass) {
        BeanDefinition def = this.getBeanDefinition(this.getBeanNameCreator().create(beanClass));
        if (def != null && beanClass.isAssignableFrom(def.getBeanClass())) {
            return def;
        }
        for (BeanDefinition definition : this.getBeanDefinitions().values()) {
            if (!beanClass.isAssignableFrom(definition.getBeanClass())) continue;
            return definition;
        }
        return null;
    }

    @Override
    public boolean containsBeanDefinition(String beanName) {
        return this.getBeanDefinitions().containsKey(beanName);
    }

    @Override
    public boolean containsBeanDefinition(Class<?> type) {
        return this.containsBeanDefinition(type, false);
    }

    @Override
    public boolean containsBeanDefinition(Class<?> type, boolean equals) {
        Predicate<BeanDefinition> predicate = this.getPredicate(type, equals);
        BeanDefinition def = this.getBeanDefinition(this.getBeanNameCreator().create(type));
        if (def != null && predicate.test(def)) {
            return true;
        }
        for (BeanDefinition beanDef : this.getBeanDefinitions().values()) {
            if (!predicate.test(beanDef)) continue;
            return true;
        }
        return false;
    }

    private Predicate<BeanDefinition> getPredicate(Class<?> type, boolean equals) {
        return equals ? beanDef -> type == beanDef.getBeanClass() : beanDef -> type.isAssignableFrom(beanDef.getBeanClass());
    }

    @Override
    public Set<String> getBeanDefinitionNames() {
        return this.getBeanDefinitions().keySet();
    }

    @Override
    public int getBeanDefinitionCount() {
        return this.getBeanDefinitions().size();
    }

    public Set<BeanReferencePropertySetter> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void initializeSingletons() {
        log.debug("Initialization of singleton objects.");
        for (BeanDefinition def : this.getBeanDefinitions().values()) {
            if (!def.isSingleton() || def.isInitialized() || def.isLazyInit()) continue;
            if (def.isFactoryBean()) {
                FactoryBean factoryBean = this.getFactoryBeanInstance(def);
                boolean isEagerInit = factoryBean instanceof SmartFactoryBean && ((SmartFactoryBean)factoryBean).isEagerInit();
                if (!isEagerInit) continue;
                this.getBean(def);
                continue;
            }
            this.createSingleton(def);
        }
        for (Object singleton : this.getSingletons().values()) {
            this.postSingletonInitialization(singleton);
        }
        log.debug("The singleton objects are initialized.");
    }

    protected void postSingletonInitialization(Object singleton) {
        if (singleton instanceof SmartInitializingSingleton) {
            ((SmartInitializingSingleton)singleton).afterSingletonsInstantiated();
        }
    }

    public void preInitialization() {
        boolean debugEnabled = log.isDebugEnabled();
        for (Map.Entry<String, Object> entry : new HashMap<String, Object>(this.getSingletons()).entrySet()) {
            String name = entry.getKey();
            BeanDefinition def = this.getBeanDefinition(name);
            if (def == null || def.isInitialized()) continue;
            this.initializeSingleton(entry.getValue(), def);
            if (!debugEnabled) continue;
            log.debug("Pre initialize singleton bean is being stored in the name of [{}].", (Object)name);
        }
    }

    @Override
    public void refresh(String name) {
        BeanDefinition def = this.obtainBeanDefinition(name);
        if (!def.isInitialized()) {
            this.createSingleton(def);
        } else if (log.isWarnEnabled()) {
            log.warn("A bean named: [{}] has already initialized", (Object)name);
        }
    }

    @Override
    public Object refresh(BeanDefinition def) {
        return this.getBean(def);
    }

    public abstract BeanDefinitionLoader getBeanDefinitionLoader();

    public BeanNameCreator getBeanNameCreator() {
        BeanNameCreator ret = this.beanNameCreator;
        if (ret == null) {
            this.beanNameCreator = ret = this.createBeanNameCreator();
        }
        return ret;
    }

    protected BeanNameCreator createBeanNameCreator() {
        return new DefaultBeanNameCreator(true);
    }

    public final List<BeanPostProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    @Override
    public void enableFullPrototype() {
        this.setFullPrototype(true);
    }

    @Override
    public void enableFullLifecycle() {
        this.setFullLifecycle(true);
    }

    @Override
    public boolean isFullPrototype() {
        return this.fullPrototype;
    }

    @Override
    public boolean isFullLifecycle() {
        return this.fullLifecycle;
    }

    @Override
    public void setFullPrototype(boolean fullPrototype) {
        this.fullPrototype = fullPrototype;
    }

    @Override
    public void setFullLifecycle(boolean fullLifecycle) {
        this.fullLifecycle = fullLifecycle;
    }

    public void setBeanNameCreator(BeanNameCreator beanNameCreator) {
        this.beanNameCreator = beanNameCreator;
    }

    @Override
    public <T> T createBean(Class<T> beanClass, boolean cacheBeanDef) {
        BeanDefinition defToUse;
        if (cacheBeanDef) {
            defToUse = this.getBeanDefinition(beanClass);
            if (defToUse == null) {
                defToUse = this.getPrototypeBeanDefinition(beanClass);
                this.registerBean(defToUse);
            }
        } else {
            defToUse = this.getPrototypeBeanDefinition(beanClass);
        }
        return (T)this.getBean(defToUse);
    }

    @Override
    public void autowireBean(Object existingBean) {
        Class<Object> userClass = ClassUtils.getUserClass(existingBean);
        BeanDefinition prototypeDef = this.getPrototypeBeanDefinition(userClass);
        if (log.isDebugEnabled()) {
            log.debug("Autowiring bean named: [{}].", (Object)prototypeDef.getName());
        }
        this.aware(existingBean, prototypeDef);
        this.applyPropertyValues(existingBean, prototypeDef);
        this.invokeInitMethods(existingBean, prototypeDef);
    }

    @Override
    public void autowireBeanProperties(Object existingBean) {
        Class<Object> userClass = ClassUtils.getUserClass(existingBean);
        BeanDefinition prototypeDef = this.getPrototypeBeanDefinition(userClass);
        if (log.isDebugEnabled()) {
            log.debug("Autowiring bean properties named: [{}].", (Object)prototypeDef.getName());
        }
        this.applyPropertyValues(existingBean, prototypeDef);
    }

    @Override
    public Object initializeBean(Object existingBean) throws BeanInitializingException {
        return this.initializeBean(existingBean, this.getBeanNameCreator().create(existingBean.getClass()));
    }

    @Override
    public Object initializeBean(Object existingBean, String beanName) {
        BeanDefinition prototypeDef = this.getPrototypeBeanDefinition(existingBean, beanName);
        return this.initializeBean(existingBean, prototypeDef);
    }

    @Override
    public Object applyBeanPostProcessorsBeforeInitialization(Object existingBean, String beanName) {
        Object ret = existingBean;
        BeanDefinition prototypeDef = this.getPrototypeBeanDefinition(existingBean, beanName);
        for (BeanPostProcessor processor : this.getPostProcessors()) {
            try {
                ret = processor.postProcessBeforeInitialization(ret, prototypeDef);
            }
            catch (Exception e) {
                throw new BeanInitializingException("An Exception Occurred When [" + existingBean + "] before properties set", e);
            }
        }
        return ret;
    }

    @Override
    public Object applyBeanPostProcessorsAfterInitialization(Object existingBean, String beanName) {
        Object ret = existingBean;
        BeanDefinition prototypeDef = this.getPrototypeBeanDefinition(existingBean, beanName);
        for (BeanPostProcessor processor : this.getPostProcessors()) {
            try {
                ret = processor.postProcessAfterInitialization(ret, prototypeDef);
            }
            catch (Exception e) {
                throw new BeanInitializingException("An Exception Occurred When [" + existingBean + "] after properties set", e);
            }
        }
        return ret;
    }

    @Override
    public void destroyBean(Object existingBean) {
        this.destroyBean(existingBean, this.getPrototypeBeanDefinition(ClassUtils.getUserClass(existingBean)));
    }

    private BeanDefinition getPrototypeBeanDefinition(Class<?> beanClass) {
        return this.getBeanDefinitionLoader().createBeanDefinition(beanClass).setScope("prototype");
    }

    private BeanDefinition getPrototypeBeanDefinition(Object existingBean, String beanName) {
        return this.getPrototypeBeanDefinition(ClassUtils.getUserClass(existingBean)).setName(beanName);
    }

    public String toString() {
        return ObjectUtils.toHexString(this) + ": defining beans [" + StringUtils.collectionToString(this.beanDefinitionMap.keySet()) + "]";
    }

    static final class ObjectFactoryTargetSource
    implements TargetSource {
        private final Class<?> targetType;
        private final ObjectFactory<?> objectFactory;

        ObjectFactoryTargetSource(ObjectFactory<?> objectFactory, Class<?> targetType) {
            this.targetType = targetType;
            this.objectFactory = objectFactory;
        }

        @Override
        public Class<?> getTargetClass() {
            return this.targetType;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public Object getTarget() throws Exception {
            return this.objectFactory.getObject();
        }
    }
}

