/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.exception;

import cn.taketoday.context.NestedRuntimeException;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.logger.LoggerFactory;
import java.util.function.Supplier;

public class ConfigurationException
extends NestedRuntimeException {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ConfigurationException.class);

    public ConfigurationException() {
    }

    public ConfigurationException(String message) {
        this(message, null);
    }

    public ConfigurationException(Throwable cause) {
        this(null, cause);
    }

    public ConfigurationException(String message, Throwable cause) {
        super(message, cause);
        log.error("Configuration Exception Message: [" + message + "]", this);
    }

    public static <T> T nonNull(T obj) {
        return ConfigurationException.nonNull(obj, "object must not be null");
    }

    public static <T> T nonNull(T obj, String msg) {
        if (obj == null) {
            throw new ConfigurationException(msg);
        }
        return obj;
    }

    public static <T> T nonNull(T obj, Supplier<String> msg) {
        if (obj == null) {
            throw new ConfigurationException(msg.get());
        }
        return obj;
    }
}

