/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.event;

import cn.taketoday.context.AbstractApplicationContext;
import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.OrderedSupport;
import cn.taketoday.context.event.ApplicationListener;
import cn.taketoday.context.event.ContextCloseEvent;
import cn.taketoday.context.factory.AbstractBeanFactory;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.ContextUtils;
import cn.taketoday.context.utils.ExceptionUtils;
import java.text.SimpleDateFormat;
import java.util.Map;

public class ContextCloseListener
extends OrderedSupport
implements ApplicationListener<ContextCloseEvent> {
    public ContextCloseListener() {
        this(-1073741823);
    }

    public ContextCloseListener(int order) {
        super(order);
    }

    @Override
    public void onApplicationEvent(ContextCloseEvent event) {
        ApplicationContext context = event.getApplicationContext();
        Logger log = LoggerFactory.getLogger(this.getClass());
        log.info("Closing: [{}] at [{}]", (Object)context, (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(event.getTimestamp()));
        for (String string : context.getBeanDefinitions().keySet()) {
            try {
                context.destroyBean(string);
                context.removeBean(string);
            }
            catch (Throwable throwable) {
                log.error(throwable.getMessage(), throwable);
            }
        }
        Map<String, Object> singletons = context.getSingletons();
        for (Map.Entry<String, Object> entry : singletons.entrySet()) {
            try {
                ContextUtils.destroyBean(entry.getValue());
            }
            catch (Throwable e) {
                e = ExceptionUtils.unwrapThrowable(e);
                log.error(e.getMessage(), e);
            }
        }
        singletons.clear();
        if (context instanceof AbstractApplicationContext) {
            AbstractBeanFactory abstractBeanFactory = ((AbstractApplicationContext)context).getBeanFactory();
            abstractBeanFactory.getDependencies().clear();
            abstractBeanFactory.getPostProcessors().clear();
        }
        ClassUtils.clearCache();
    }
}

