/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.env;

import cn.taketoday.context.BeanNameCreator;
import cn.taketoday.context.annotation.Autowired;
import cn.taketoday.context.env.Environment;
import cn.taketoday.context.utils.Assert;

public class DefaultBeanNameCreator
implements BeanNameCreator {
    private final boolean useSimpleName;

    public DefaultBeanNameCreator() {
        this(true);
    }

    public DefaultBeanNameCreator(boolean useSimpleName) {
        this.useSimpleName = useSimpleName;
    }

    @Autowired
    public DefaultBeanNameCreator(Environment environment) {
        this(environment.getFlag("context.name.simple", true));
    }

    @Override
    public String create(Class<?> beanClass) {
        Assert.notNull(beanClass, "Bean class must not be null");
        if (this.useSimpleName) {
            String simpleName = beanClass.getSimpleName();
            char c = simpleName.charAt(0);
            if (c > '@' && c < '[') {
                return new StringBuilder(simpleName).deleteCharAt(0).insert(0, (char)(c | 0x20)).toString();
            }
            return simpleName;
        }
        return beanClass.getName();
    }
}

