/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.support.StringSourceTypeConverter;
import cn.taketoday.context.utils.CollectionUtils;
import cn.taketoday.context.utils.GenericDescriptor;
import cn.taketoday.context.utils.StringUtils;
import java.util.Collection;

final class StringToCollectionConverter
extends StringSourceTypeConverter {
    private final ConversionService conversionService;

    public StringToCollectionConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public boolean supportsInternal(GenericDescriptor targetType, Class<?> sourceType) {
        return targetType.isCollection();
    }

    @Override
    protected Object convertInternal(GenericDescriptor targetType, String string) {
        String[] fields = StringUtils.split(string);
        GenericDescriptor elementType = targetType.getGeneric(Collection.class);
        Collection<String> target = CollectionUtils.createCollection(targetType.getType(), elementType != null ? elementType.getType() : null, fields.length);
        if (elementType == null) {
            for (String field : fields) {
                target.add(field.trim());
            }
        } else {
            ConversionService conversionService = this.conversionService;
            for (String field : fields) {
                Object targetElement = conversionService.convert((Object)field.trim(), elementType);
                target.add((String)targetElement);
            }
        }
        return target;
    }
}

