/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.support.ToArrayConverter;
import cn.taketoday.context.utils.GenericDescriptor;
import java.lang.reflect.Array;

final class ObjectToArrayConverter
extends ToArrayConverter {
    private final ConversionService conversionService;

    public ObjectToArrayConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    protected boolean supportsInternal(GenericDescriptor targetType, Class<?> sourceType) {
        Class<?> componentType = targetType.getComponentType();
        return this.conversionService.canConvert(sourceType, componentType);
    }

    @Override
    public Object convert(GenericDescriptor targetType, Object source) {
        GenericDescriptor targetElementType = targetType.getElementDescriptor();
        Object target = Array.newInstance(targetElementType.getType(), 1);
        Object targetElement = this.conversionService.convert(source, targetElementType);
        Array.set(target, 0, targetElement);
        return target;
    }
}

