/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.Ordered;
import cn.taketoday.context.conversion.ConfigurableConversionService;
import cn.taketoday.context.conversion.ConversionFailedException;
import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.Converter;
import cn.taketoday.context.conversion.ConverterNotFoundException;
import cn.taketoday.context.conversion.ConverterRegistry;
import cn.taketoday.context.conversion.TypeCapable;
import cn.taketoday.context.conversion.TypeConverter;
import cn.taketoday.context.conversion.support.ArrayToArrayConverter;
import cn.taketoday.context.conversion.support.ArrayToCollectionConverter;
import cn.taketoday.context.conversion.support.ArrayToObjectConverter;
import cn.taketoday.context.conversion.support.ArrayToStringConverter;
import cn.taketoday.context.conversion.support.BigDecimalConverter;
import cn.taketoday.context.conversion.support.ByteBufferConverter;
import cn.taketoday.context.conversion.support.ByteConverter;
import cn.taketoday.context.conversion.support.CharsetConverter;
import cn.taketoday.context.conversion.support.ClassConverter;
import cn.taketoday.context.conversion.support.CollectionToArrayConverter;
import cn.taketoday.context.conversion.support.CollectionToCollectionConverter;
import cn.taketoday.context.conversion.support.CollectionToObjectConverter;
import cn.taketoday.context.conversion.support.CollectionToStringConverter;
import cn.taketoday.context.conversion.support.DataSizeConverter;
import cn.taketoday.context.conversion.support.DoubleConverter;
import cn.taketoday.context.conversion.support.DurationConverter;
import cn.taketoday.context.conversion.support.EnumToStringConverter;
import cn.taketoday.context.conversion.support.FallbackConverter;
import cn.taketoday.context.conversion.support.FloatConverter;
import cn.taketoday.context.conversion.support.IdToEntityConverter;
import cn.taketoday.context.conversion.support.IntegerConverter;
import cn.taketoday.context.conversion.support.IntegerToEnumConverter;
import cn.taketoday.context.conversion.support.LongConverter;
import cn.taketoday.context.conversion.support.MapToMapConverter;
import cn.taketoday.context.conversion.support.MediaTypeConverter;
import cn.taketoday.context.conversion.support.MimeTypeConverter;
import cn.taketoday.context.conversion.support.NumberToCharacterConverter;
import cn.taketoday.context.conversion.support.ObjectToArrayConverter;
import cn.taketoday.context.conversion.support.ObjectToCollectionConverter;
import cn.taketoday.context.conversion.support.ObjectToObjectConverter;
import cn.taketoday.context.conversion.support.ObjectToOptionalConverter;
import cn.taketoday.context.conversion.support.ObjectToStringConverter;
import cn.taketoday.context.conversion.support.PropertiesToStringConverter;
import cn.taketoday.context.conversion.support.ShortConverter;
import cn.taketoday.context.conversion.support.StreamConverter;
import cn.taketoday.context.conversion.support.StringToArrayConverter;
import cn.taketoday.context.conversion.support.StringToBooleanConverter;
import cn.taketoday.context.conversion.support.StringToCharacterConverter;
import cn.taketoday.context.conversion.support.StringToCharsetConverter;
import cn.taketoday.context.conversion.support.StringToCollectionConverter;
import cn.taketoday.context.conversion.support.StringToCurrencyConverter;
import cn.taketoday.context.conversion.support.StringToEnumConverter;
import cn.taketoday.context.conversion.support.StringToLocaleConverter;
import cn.taketoday.context.conversion.support.StringToPropertiesConverter;
import cn.taketoday.context.conversion.support.StringToResourceConverter;
import cn.taketoday.context.conversion.support.StringToTimeZoneConverter;
import cn.taketoday.context.conversion.support.StringToUUIDConverter;
import cn.taketoday.context.conversion.support.ZoneIdToTimeZoneConverter;
import cn.taketoday.context.conversion.support.ZonedDateTimeToCalendarConverter;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.GenericDescriptor;
import cn.taketoday.context.utils.GenericTypeResolver;
import cn.taketoday.context.utils.Mappings;
import cn.taketoday.context.utils.ObjectUtils;
import cn.taketoday.context.utils.OrderUtils;
import cn.taketoday.context.utils.ResolvableType;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Currency;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class DefaultConversionService
implements ConfigurableConversionService {
    private static final NopTypeConverter NO_MATCH = new NopTypeConverter();
    private static DefaultConversionService sharedInstance = new DefaultConversionService();
    private final LinkedList<TypeConverter> converters = new LinkedList();
    private final ConverterMappings converterMappings = new ConverterMappings();

    @Override
    public boolean canConvert(Class<?> sourceType, GenericDescriptor targetType) {
        return this.getConverter(sourceType, targetType) != null;
    }

    @Override
    public <T> T convert(Object source, GenericDescriptor targetType) {
        if (source == null) {
            return this.convertNull(targetType);
        }
        Assert.notNull((Object)targetType, "targetType must not be null");
        TypeConverter typeConverter = this.getConverter(source.getClass(), targetType);
        if (typeConverter == null) {
            return this.handleConverterNotFound(source, targetType);
        }
        try {
            return (T)typeConverter.convert(targetType, source);
        }
        catch (ConversionFailedException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new ConversionFailedException(ex, source, targetType);
        }
    }

    protected <T> T handleConverterNotFound(Object source, GenericDescriptor targetType) {
        if (targetType.isInstance(source)) {
            return (T)source;
        }
        throw new ConverterNotFoundException(source, targetType);
    }

    protected <T> T convertNull(GenericDescriptor targetType) {
        if (targetType.is(Optional.class)) {
            return (T)Optional.empty();
        }
        return null;
    }

    @Override
    public TypeConverter getConverter(Class<?> sourceType, GenericDescriptor targetType) {
        ConverterKey key = new ConverterKey(targetType, sourceType);
        TypeConverter typeConverter = (TypeConverter)this.converterMappings.get((Object)key, targetType);
        if (typeConverter != NO_MATCH) {
            return typeConverter;
        }
        return null;
    }

    @Override
    public void addConverters(TypeConverter ... converters) {
        if (ObjectUtils.isNotEmpty(converters)) {
            Collections.addAll(this.converters, converters);
            OrderUtils.reversedSort(this.converters);
            this.invalidateCache();
        }
    }

    @Override
    public void addConverter(TypeConverter converter) {
        this.converters.add(converter);
        OrderUtils.reversedSort(this.converters);
        this.invalidateCache();
    }

    @Override
    public void addConverters(List<TypeConverter> converters) {
        if (ObjectUtils.isNotEmpty(converters)) {
            this.converters.addAll(converters);
            OrderUtils.reversedSort(this.converters);
            this.invalidateCache();
        }
    }

    public List<TypeConverter> getConverters() {
        return this.converters;
    }

    @Override
    public void setConverters(TypeConverter ... converters) {
        Assert.notNull((Object)converters, "TypeConverter must not be null");
        this.converters.clear();
        this.invalidateCache();
        Collections.addAll(this.converters, OrderUtils.reversedSort(converters));
    }

    @Override
    public void addConverters(Converter<?, ?> ... converters) {
        if (ObjectUtils.isNotEmpty(converters)) {
            for (Converter<?, ?> converter : converters) {
                this.addConverter(converter);
            }
        }
    }

    @Override
    public <S, T> void addConverter(Converter<S, T> converter) {
        if (converter instanceof TypeCapable) {
            Class<?> targetType = ((TypeCapable)((Object)converter)).getType();
            this.addConverter(targetType, converter);
        } else {
            Assert.notNull(converter, "converter must not be null");
            Object[] generics = GenericTypeResolver.resolveTypeArguments(converter.getClass(), Converter.class);
            if (ObjectUtils.isNotEmpty(generics)) {
                Object targetType = generics[1];
                Object sourceType = generics[0];
                this.addConverter((Class<T>)targetType, (Class<S>)sourceType, (Converter<? super S, ? extends T>)converter);
            } else {
                throw new ConfigurationException("can't register get converter's target class");
            }
        }
    }

    @Override
    public <S, T> void addConverter(Class<T> targetType, Converter<? super S, ? extends T> converter) {
        Assert.notNull(converter, "converter must not be null");
        ResolvableType type = ResolvableType.forClass(converter.getClass()).as(Converter.class);
        if (!type.hasGenerics()) {
            throw new ConfigurationException("can't register get converter's source class");
        }
        ResolvableType generic = type.getGeneric(0);
        this.addConverter(targetType, generic.toClass(), converter);
    }

    @Override
    public <S, T> void addConverter(Class<T> targetType, Class<S> sourceType, Converter<? super S, ? extends T> converter) {
        Assert.notNull(converter, "converter must not be null");
        Assert.notNull(targetType, "targetType must not be null");
        Assert.notNull(sourceType, "sourceType must not be null");
        GenericConverter genericConverter = new GenericConverter(targetType, sourceType, converter);
        this.converters.add(genericConverter);
        this.invalidateCache();
        OrderUtils.reversedSort(this.converters);
    }

    void invalidateCache() {
        this.converterMappings.clear();
    }

    public static void setSharedInstance(DefaultConversionService sharedInstance) {
        DefaultConversionService.sharedInstance = sharedInstance;
    }

    public static DefaultConversionService getSharedInstance() {
        return sharedInstance;
    }

    public static void addDefaultConverters(ConverterRegistry registry) {
        DefaultConversionService.addScalarConverters(registry);
        DefaultConversionService.addCollectionConverters(registry);
        registry.addConverters(new StringToTimeZoneConverter(), new ZoneIdToTimeZoneConverter(), new ZonedDateTimeToCalendarConverter());
        registry.addConverters(new StringToResourceConverter(), new ByteBufferConverter((ConversionService)((Object)registry)), new IdToEntityConverter((ConversionService)((Object)registry)), new ObjectToOptionalConverter((ConversionService)((Object)registry)), new PrimitiveClassConverter(), new ObjectToObjectConverter(), new FallbackConverter());
    }

    public static void addCollectionConverters(ConverterRegistry registry) {
        ConversionService conversionService = (ConversionService)((Object)registry);
        registry.addConverters(new ArrayToCollectionConverter(conversionService));
        registry.addConverters(new CollectionToArrayConverter(conversionService));
        registry.addConverters(new ArrayToArrayConverter(conversionService));
        registry.addConverters(new CollectionToCollectionConverter(conversionService));
        registry.addConverters(new MapToMapConverter(conversionService));
        registry.addConverters(new ArrayToStringConverter(conversionService));
        registry.addConverters(new StringToArrayConverter(conversionService));
        registry.addConverters(new ArrayToObjectConverter(conversionService));
        registry.addConverters(new ObjectToArrayConverter(conversionService));
        registry.addConverters(new CollectionToStringConverter(conversionService));
        registry.addConverters(new StringToCollectionConverter(conversionService));
        registry.addConverters(new CollectionToObjectConverter(conversionService));
        registry.addConverters(new ObjectToCollectionConverter(conversionService));
        registry.addConverters(new StreamConverter(conversionService));
    }

    private static void addScalarConverters(ConverterRegistry registry) {
        registry.addConverters(new IntegerConverter(Integer.TYPE), new IntegerConverter(Integer.class), new LongConverter(Long.class), new LongConverter(Long.TYPE), new DoubleConverter(Double.class), new DoubleConverter(Double.TYPE), new FloatConverter(Float.TYPE), new FloatConverter(Float.class), new ByteConverter(Byte.class), new ByteConverter(Byte.TYPE), new ShortConverter(Short.TYPE), new ShortConverter(Short.class), new BigDecimalConverter(BigDecimal.class), new BigDecimalConverter(Number.class), new StringToCharacterConverter(Character.TYPE), new StringToCharacterConverter(Character.class), new ClassConverter(), new CharsetConverter(), new DurationConverter(), new DataSizeConverter(), new MimeTypeConverter(), new MediaTypeConverter());
        registry.addConverter(String.class, Number.class, ObjectToStringConverter.INSTANCE);
        registry.addConverter(String.class, Character.class, ObjectToStringConverter.INSTANCE);
        registry.addConverter(new NumberToCharacterConverter());
        StringToBooleanConverter converter = new StringToBooleanConverter();
        registry.addConverter(Boolean.TYPE, String.class, converter);
        registry.addConverter(Boolean.class, String.class, converter);
        registry.addConverter(String.class, Boolean.class, ObjectToStringConverter.INSTANCE);
        registry.addConverters(new StringToEnumConverter());
        registry.addConverter(new EnumToStringConverter());
        registry.addConverters(new IntegerToEnumConverter());
        registry.addConverter(new StringToLocaleConverter());
        registry.addConverter(String.class, Locale.class, ObjectToStringConverter.INSTANCE);
        registry.addConverter(new StringToCharsetConverter());
        registry.addConverter(String.class, Charset.class, ObjectToStringConverter.INSTANCE);
        registry.addConverter(new StringToCurrencyConverter());
        registry.addConverter(String.class, Currency.class, ObjectToStringConverter.INSTANCE);
        registry.addConverter(new StringToPropertiesConverter());
        registry.addConverter(new PropertiesToStringConverter());
        registry.addConverter(new StringToUUIDConverter());
        registry.addConverter(String.class, UUID.class, ObjectToStringConverter.INSTANCE);
    }

    static {
        DefaultConversionService.addDefaultConverters(sharedInstance);
    }

    static final class GenericConverter
    implements TypeConverter,
    Ordered {
        final Class<?> targetType;
        final Class<?> sourceType;
        final Converter converter;

        GenericConverter(Class<?> targetType, Class<?> sourceType, Converter converter) {
            this.converter = converter;
            this.targetType = targetType;
            this.sourceType = sourceType;
        }

        @Override
        public boolean supports(GenericDescriptor targetType, Class<?> sourceType) {
            return targetType.is(this.targetType) && (this.sourceType == sourceType || this.sourceType.isAssignableFrom(sourceType));
        }

        @Override
        public Object convert(GenericDescriptor targetType, Object source) {
            return this.converter.convert(source);
        }

        @Override
        public int getOrder() {
            return 0x3FFFFFFF;
        }
    }

    static class NopTypeConverter
    implements TypeConverter {
        NopTypeConverter() {
        }

        @Override
        public boolean supports(GenericDescriptor targetType, Class<?> sourceType) {
            return false;
        }

        @Override
        public Object convert(GenericDescriptor targetType, Object source) {
            return source;
        }
    }

    static class PrimitiveClassConverter
    implements TypeConverter {
        PrimitiveClassConverter() {
        }

        @Override
        public boolean supports(GenericDescriptor targetType, Class<?> source) {
            Class<?> targetClass = targetType.isArray() ? targetType.getComponentType() : targetType.getType();
            return targetClass == Boolean.TYPE && source == Boolean.class || targetClass == Long.TYPE && source == Long.class || targetClass == Integer.TYPE && source == Integer.class || targetClass == Float.TYPE && source == Float.class || targetClass == Short.TYPE && source == Short.class || targetClass == Double.TYPE && source == Double.class || targetClass == Character.TYPE && source == Character.class || targetClass == Byte.TYPE && source == Byte.class;
        }

        @Override
        public Object convert(GenericDescriptor targetClass, Object source) {
            return source;
        }
    }

    static final class ConverterKey {
        private final int hash;
        final Class<?> sourceType;
        final GenericDescriptor targetType;

        ConverterKey(GenericDescriptor targetType, Class<?> sourceType) {
            this.targetType = targetType;
            this.sourceType = sourceType;
            this.hash = this.sourceType.hashCode() * 31 + this.targetType.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConverterKey)) {
                return false;
            }
            ConverterKey that = (ConverterKey)o;
            return this.sourceType == that.sourceType && Objects.equals(this.targetType, that.targetType);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    class ConverterMappings
    extends Mappings<TypeConverter, GenericDescriptor> {
        ConverterMappings() {
        }

        @Override
        protected TypeConverter createValue(Object key, GenericDescriptor targetType) {
            Class<?> sourceType = ((ConverterKey)key).sourceType;
            for (TypeConverter converter : DefaultConversionService.this.converters) {
                if (!converter.supports(targetType, sourceType)) continue;
                return converter;
            }
            return NO_MATCH;
        }
    }
}

