/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.support.CollectionSourceConverter;
import cn.taketoday.context.utils.GenericDescriptor;
import java.util.Collection;
import java.util.StringJoiner;

final class CollectionToStringConverter
extends CollectionSourceConverter {
    private static final String DELIMITER = ",";
    private final ConversionService conversionService;

    public CollectionToStringConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    protected boolean supportsInternal(GenericDescriptor targetType, Class<?> sourceType) {
        return targetType.is(String.class);
    }

    @Override
    protected Object convertInternal(GenericDescriptor targetType, Collection<?> sourceCollection) {
        if (sourceCollection.isEmpty()) {
            return "";
        }
        StringJoiner sj = new StringJoiner(DELIMITER);
        ConversionService conversionService = this.conversionService;
        for (Object sourceElement : sourceCollection) {
            Object targetElement = conversionService.convert(sourceElement, targetType);
            sj.add(String.valueOf(targetElement));
        }
        return sj.toString();
    }
}

