/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.support.StringSourceConverter;
import cn.taketoday.context.exception.ConversionException;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;

public class ClassConverter
extends StringSourceConverter<Class<?>> {
    private ClassLoader classLoader = ClassUtils.getClassLoader();

    @Override
    public Class<?> convert(String source) {
        try {
            return this.loadClass(source);
        }
        catch (ClassNotFoundException e) {
            return this.fallback(source, e);
        }
    }

    protected Class<?> fallback(String source, ClassNotFoundException e) {
        throw new ConversionException(e);
    }

    protected Class<?> loadClass(String source) throws ClassNotFoundException {
        return this.obtainClassLoader().loadClass(source);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    final ClassLoader obtainClassLoader() {
        ClassLoader classLoader = this.getClassLoader();
        Assert.state(classLoader != null, "No ClassLoader.");
        return classLoader;
    }
}

