/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.conversion.support;

import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.TypeConverter;
import cn.taketoday.context.conversion.support.ArraySourceConverter;
import cn.taketoday.context.utils.GenericDescriptor;
import java.lang.reflect.Array;

final class ArrayToArrayConverter
extends ArraySourceConverter
implements TypeConverter {
    private final ConversionService conversionService;

    public ArrayToArrayConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    protected boolean supportsInternal(GenericDescriptor targetType, Class<?> sourceType) {
        return targetType.isArray();
    }

    @Override
    public Object convert(GenericDescriptor targetType, Object source) {
        Class<?> elementType = targetType.getComponentType();
        int length = Array.getLength(source);
        Object array = Array.newInstance(elementType, length);
        ConversionService conversionService = this.conversionService;
        for (int i = 0; i < length; ++i) {
            Object sourceElement = Array.get(source, i);
            Object targetElement = conversionService.convert(sourceElement, elementType);
            Array.set(array, i, targetElement);
        }
        return array;
    }
}

