/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.util;

import cn.taketoday.context.asm.ClassVisitor;
import cn.taketoday.context.asm.Label;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.AbstractClassGenerator;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.ClassEmitter;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.EmitUtils;
import cn.taketoday.context.cglib.core.KeyFactory;
import cn.taketoday.context.cglib.core.ObjectSwitchCallback;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.core.TypeUtils;
import java.util.Arrays;
import java.util.List;

public abstract class StringSwitcher {
    private static final Type STRING_SWITCHER = TypeUtils.parseType(StringSwitcher.class);
    private static final Signature INT_VALUE = TypeUtils.parseSignature("int intValue(String)");
    private static final StringSwitcherKey KEY_FACTORY = KeyFactory.create(StringSwitcherKey.class);

    public static StringSwitcher create(String[] strings, int[] ints, boolean fixedInput) {
        Generator gen = new Generator();
        gen.setStrings(strings);
        gen.setInts(ints);
        gen.setFixedInput(fixedInput);
        return gen.create();
    }

    protected StringSwitcher() {
    }

    public abstract int intValue(String var1);

    public static class Generator
    extends AbstractClassGenerator {
        private int[] ints;
        private String[] strings;
        private boolean fixedInput;

        public Generator() {
            super(StringSwitcher.class);
        }

        public void setStrings(String[] strings) {
            this.strings = strings;
        }

        public void setInts(int[] ints) {
            this.ints = ints;
        }

        public void setFixedInput(boolean fixedInput) {
            this.fixedInput = fixedInput;
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.getClass().getClassLoader();
        }

        public StringSwitcher create() {
            this.setNamePrefix(StringSwitcher.class.getName());
            Object key = KEY_FACTORY.newInstance(this.strings, this.ints, this.fixedInput);
            return (StringSwitcher)super.create(key);
        }

        @Override
        public void generateClass(ClassVisitor v) throws Exception {
            ClassEmitter ce = new ClassEmitter(v);
            ce.beginClass(52, 1, this.getClassName(), STRING_SWITCHER, null, "<cglibGenerated>");
            EmitUtils.nullConstructor(ce);
            final CodeEmitter e = ce.beginMethod(1, INT_VALUE, new Type[0]);
            e.load_arg(0);
            final List<String> stringList = Arrays.asList(this.strings);
            int style = this.fixedInput ? 2 : 1;
            EmitUtils.stringSwitch(e, this.strings, style, new ObjectSwitchCallback(){

                @Override
                public void processCase(Object key, Label end) {
                    e.push(ints[stringList.indexOf(key)]);
                    e.return_value();
                }

                @Override
                public void processDefault() {
                    e.push(-1);
                    e.return_value();
                }
            });
            e.end_method();
            ce.endClass();
        }

        protected Object firstInstance(Class type) {
            return CglibReflectUtils.newInstance(type);
        }

        @Override
        protected Object nextInstance(Object instance) {
            return instance;
        }
    }

    static interface StringSwitcherKey {
        public Object newInstance(String[] var1, int[] var2, boolean var3);
    }
}

