/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.transform.impl;

import cn.taketoday.context.Constant;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.EmitUtils;
import cn.taketoday.context.cglib.core.MethodInfo;
import cn.taketoday.context.cglib.transform.ClassEmitterTransformer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class AddStaticInitTransformer
extends ClassEmitterTransformer {
    private final MethodInfo info;

    public AddStaticInitTransformer(Method classInit) {
        this.info = CglibReflectUtils.getMethodInfo(classInit);
        if (!Modifier.isStatic(this.info.getModifiers())) {
            throw new IllegalArgumentException(classInit + " is not static");
        }
        Type[] types = this.info.getSignature().getArgumentTypes();
        if (types.length != 1 || !types[0].equals(Constant.TYPE_CLASS) || !this.info.getSignature().getReturnType().equals(Type.VOID_TYPE)) {
            throw new IllegalArgumentException(classInit + " illegal signature");
        }
    }

    @Override
    protected void init() {
        if (!Modifier.isInterface(this.getAccess())) {
            CodeEmitter e = this.getStaticHook();
            EmitUtils.loadClassThis(e);
            e.invoke(this.info);
        }
    }
}

