/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.reflect;

import cn.taketoday.context.Constant;
import cn.taketoday.context.asm.ClassVisitor;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.AbstractClassGenerator;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.ClassEmitter;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.EmitUtils;
import cn.taketoday.context.cglib.core.Local;
import cn.taketoday.context.cglib.core.MethodInfo;
import cn.taketoday.context.cglib.core.ProcessArrayCallback;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.core.TypeUtils;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.List;

public abstract class MulticastDelegate
implements Cloneable {
    protected Object[] targets = Constant.EMPTY_OBJECT_ARRAY;

    protected MulticastDelegate() {
    }

    public List<Object> getTargets() {
        return Arrays.asList(this.targets);
    }

    public abstract MulticastDelegate add(Object var1);

    protected MulticastDelegate addHelper(Object target) {
        MulticastDelegate copy = this.newInstance();
        Object[] targets = this.targets;
        copy.targets = new Object[targets.length + 1];
        System.arraycopy(targets, 0, copy.targets, 0, targets.length);
        copy.targets[targets.length] = target;
        return copy;
    }

    public MulticastDelegate remove(Object target) {
        Object[] targets = this.targets;
        for (int i = targets.length - 1; i >= 0; --i) {
            if (!targets[i].equals(target)) continue;
            MulticastDelegate copy = this.newInstance();
            copy.targets = new Object[targets.length - 1];
            System.arraycopy(targets, 0, copy.targets, 0, i);
            System.arraycopy(targets, i + 1, copy.targets, i, targets.length - i - 1);
            return copy;
        }
        return this;
    }

    public abstract MulticastDelegate newInstance();

    public static MulticastDelegate create(Class<?> iface) {
        return new Generator().setInterface(iface).create();
    }

    public static class Generator
    extends AbstractClassGenerator<Object> {
        private static final Type MULTICAST_DELEGATE = TypeUtils.parseType(MulticastDelegate.class);
        private static final Signature NEW_INSTANCE = new Signature("newInstance", MULTICAST_DELEGATE, Constant.TYPES_EMPTY_ARRAY);
        private static final Signature ADD_DELEGATE = new Signature("add", MULTICAST_DELEGATE, new Type[]{Constant.TYPE_OBJECT});
        private static final Signature ADD_HELPER = new Signature("addHelper", MULTICAST_DELEGATE, new Type[]{Constant.TYPE_OBJECT});
        private Class<?> iface;

        public Generator() {
            super(MulticastDelegate.class);
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.iface.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return CglibReflectUtils.getProtectionDomain(this.iface);
        }

        public Generator setInterface(Class<?> iface) {
            this.iface = iface;
            return this;
        }

        public MulticastDelegate create() {
            this.setNamePrefix(MulticastDelegate.class.getName());
            return (MulticastDelegate)super.create(this.iface.getName());
        }

        @Override
        public void generateClass(ClassVisitor cv) {
            MethodInfo method = CglibReflectUtils.getMethodInfo(CglibReflectUtils.findInterfaceMethod(this.iface));
            ClassEmitter ce = new ClassEmitter(cv);
            ce.beginClass(52, 1, this.getClassName(), MULTICAST_DELEGATE, Type.array(Type.getType(this.iface)), "<cglibGenerated>");
            EmitUtils.nullConstructor(ce);
            this.emitProxy(ce, method);
            CodeEmitter e = ce.beginMethod(1, NEW_INSTANCE, new Type[0]);
            e.new_instance_this();
            e.dup();
            e.invoke_constructor_this();
            e.return_value();
            e.end_method();
            e = ce.beginMethod(1, ADD_DELEGATE, new Type[0]);
            e.load_this();
            e.load_arg(0);
            e.checkcast(Type.getType(this.iface));
            e.invoke_virtual_this(ADD_HELPER);
            e.return_value();
            e.end_method();
            ce.endClass();
        }

        private void emitProxy(ClassEmitter ce, final MethodInfo method) {
            int modifiers = 1;
            if ((method.getModifiers() & 0x80) == 128) {
                modifiers |= 0x80;
            }
            final CodeEmitter e = EmitUtils.beginMethod(ce, method, modifiers);
            Type returnType = method.getSignature().getReturnType();
            final boolean returns = returnType != Type.VOID_TYPE;
            Local result = null;
            if (returns) {
                result = e.make_local(returnType);
                e.zero_or_null(returnType);
                e.store_local(result);
            }
            e.load_this();
            e.super_getfield("targets", Constant.TYPE_OBJECT_ARRAY);
            final Local result2 = result;
            EmitUtils.processArray(e, Constant.TYPE_OBJECT_ARRAY, new ProcessArrayCallback(){

                @Override
                public void processElement(Type type) {
                    e.checkcast(Type.getType(iface));
                    e.load_args();
                    e.invoke(method);
                    if (returns) {
                        e.store_local(result2);
                    }
                }
            });
            if (returns) {
                e.load_local(result);
            }
            e.return_value();
            e.end_method();
        }

        @Override
        protected Object firstInstance(Class<Object> type) {
            return ((MulticastDelegate)CglibReflectUtils.newInstance(type)).newInstance();
        }

        @Override
        protected Object nextInstance(Object instance) {
            return ((MulticastDelegate)instance).newInstance();
        }
    }
}

