/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.reflect;

import cn.taketoday.context.Constant;
import cn.taketoday.context.asm.ClassVisitor;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.AbstractClassGenerator;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.reflect.FastClassEmitter;
import cn.taketoday.context.cglib.reflect.FastConstructor;
import cn.taketoday.context.cglib.reflect.FastMethod;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;

public abstract class FastClass {
    private final Class type;

    protected FastClass(Class type) {
        this.type = type;
    }

    public static FastClass create(Class type) {
        return FastClass.create(type.getClassLoader(), type);
    }

    public static FastClass create(ClassLoader loader, Class type) {
        Generator gen = new Generator(type);
        gen.setClassLoader(loader);
        return gen.create();
    }

    public Object invoke(String name, Class[] parameterTypes, Object obj, Object[] args) throws InvocationTargetException {
        return this.invoke(this.getIndex(name, parameterTypes), obj, args);
    }

    public Object newInstance() throws InvocationTargetException {
        return this.newInstance(this.getIndex(Constant.EMPTY_CLASS_ARRAY), null);
    }

    public Object newInstance(Class[] parameterTypes, Object[] args) throws InvocationTargetException {
        return this.newInstance(this.getIndex(parameterTypes), args);
    }

    public FastMethod getMethod(Method method) {
        return new FastMethod(this, method);
    }

    public FastConstructor getConstructor(Constructor constructor) {
        return new FastConstructor(this, constructor);
    }

    public FastMethod getMethod(String name, Class[] parameterTypes) {
        try {
            return this.getMethod(this.type.getMethod(name, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    public FastConstructor getConstructor(Class[] parameterTypes) {
        try {
            return this.getConstructor(this.type.getConstructor(parameterTypes));
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    public String getName() {
        return this.type.getName();
    }

    public Class getJavaClass() {
        return this.type;
    }

    public String toString() {
        return this.type.toString();
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof FastClass)) {
            return false;
        }
        return this.type.equals(((FastClass)o).type);
    }

    public abstract int getIndex(String var1, Class[] var2);

    public abstract int getIndex(Class[] var1);

    public abstract Object invoke(int var1, Object var2, Object[] var3) throws InvocationTargetException;

    public abstract Object newInstance(int var1, Object[] var2) throws InvocationTargetException;

    public abstract int getIndex(Signature var1);

    public int getIndex(Method method) {
        return this.getIndex(new Signature(method.getName(), Type.getMethodDescriptor(method)));
    }

    public abstract int getMaxIndex();

    protected static String getSignatureWithoutReturnType(String name, Class[] parameterTypes) {
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        sb.append('(');
        for (int i = 0; i < parameterTypes.length; ++i) {
            sb.append(Type.getDescriptor(parameterTypes[i]));
        }
        sb.append(')');
        return sb.toString();
    }

    public static class Generator
    extends AbstractClassGenerator {
        private final Class<?> type;

        public Generator(Class<?> type) {
            super(FastClass.class);
            this.type = type;
        }

        public FastClass create() {
            this.setNamePrefix(this.type.getName());
            return (FastClass)super.create(this.type.getName());
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.type.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return CglibReflectUtils.getProtectionDomain(this.type);
        }

        @Override
        public void generateClass(ClassVisitor v) throws Exception {
            new FastClassEmitter(v, this.getClassName(), this.type);
        }

        protected Object firstInstance(Class type) {
            return CglibReflectUtils.newInstance(type, new Class[]{Class.class}, new Object[]{this.type});
        }

        @Override
        protected Object nextInstance(Object instance) {
            return instance;
        }
    }
}

