/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.proxy;

import cn.taketoday.context.Constant;
import cn.taketoday.context.asm.ClassVisitor;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.ClassEmitter;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.EmitUtils;
import cn.taketoday.context.cglib.core.MethodInfo;
import cn.taketoday.context.cglib.core.MethodWrapper;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.core.TypeUtils;
import cn.taketoday.context.cglib.proxy.Mixin;
import java.lang.reflect.Method;
import java.util.HashSet;

class MixinEmitter
extends ClassEmitter {
    private static final String FIELD_NAME = "TODAY$DELEGATES";
    private static final Type MIXIN = TypeUtils.parseType(Mixin.class);
    private static final Signature CSTRUCT_OBJECT_ARRAY = TypeUtils.parseConstructor("Object[]");
    private static final Signature NEW_INSTANCE = new Signature("newInstance", MIXIN, Type.array(Constant.TYPE_OBJECT_ARRAY));

    public MixinEmitter(ClassVisitor v, String className, Class<?>[] classes, int[] route) {
        super(v);
        this.beginClass(52, 1, className, MIXIN, TypeUtils.getTypes(this.getInterfaces(classes)), "<cglibGenerated>");
        EmitUtils.nullConstructor(this);
        EmitUtils.factoryMethod(this, NEW_INSTANCE);
        this.declare_field(2, FIELD_NAME, Constant.TYPE_OBJECT_ARRAY, null);
        CodeEmitter e = this.beginMethod(1, CSTRUCT_OBJECT_ARRAY, new Type[0]);
        e.load_this();
        e.super_invoke_constructor();
        e.load_this();
        e.load_arg(0);
        e.putfield(FIELD_NAME);
        e.return_value();
        e.end_method();
        HashSet<Object> unique = new HashSet<Object>();
        int accVarargs = 128;
        for (int i = 0; i < classes.length; ++i) {
            Method[] methods;
            for (Method method : methods = this.getMethods(classes[i])) {
                if (!unique.add(MethodWrapper.create(method))) continue;
                MethodInfo methodInfo = CglibReflectUtils.getMethodInfo(method);
                int modifiers = 1;
                if ((methodInfo.getModifiers() & 0x80) == 128) {
                    modifiers |= 0x80;
                }
                e = EmitUtils.beginMethod(this, methodInfo, modifiers);
                e.load_this();
                e.getfield(FIELD_NAME);
                e.aaload(route != null ? route[i] : i);
                e.checkcast(methodInfo.getClassInfo().getType());
                e.load_args();
                e.invoke(methodInfo);
                e.return_value();
                e.end_method();
            }
        }
        this.endClass();
    }

    protected Class<?>[] getInterfaces(Class<?>[] classes) {
        return classes;
    }

    protected Method[] getMethods(Class<?> type) {
        return type.getMethods();
    }
}

