/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.proxy;

import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.ClassEmitter;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.MethodInfo;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.cglib.core.TypeUtils;
import cn.taketoday.context.cglib.proxy.CallbackGenerator;
import cn.taketoday.context.cglib.proxy.Dispatcher;
import cn.taketoday.context.cglib.proxy.ProxyRefDispatcher;
import java.lang.reflect.Modifier;
import java.util.List;

class DispatcherGenerator
implements CallbackGenerator {
    public static final DispatcherGenerator INSTANCE = new DispatcherGenerator(false);
    public static final DispatcherGenerator PROXY_REF_INSTANCE = new DispatcherGenerator(true);
    private static final Type DISPATCHER = TypeUtils.parseType(Dispatcher.class);
    private static final Type PROXY_REF_DISPATCHER = TypeUtils.parseType(ProxyRefDispatcher.class);
    private static final Signature LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject()");
    private static final Signature PROXY_REF_LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject(Object)");
    private final boolean proxyRef;

    private DispatcherGenerator(boolean proxyRef) {
        this.proxyRef = proxyRef;
    }

    @Override
    public void generate(ClassEmitter ce, CallbackGenerator.Context context, List<MethodInfo> methods) {
        for (MethodInfo method : methods) {
            if (Modifier.isProtected(method.getModifiers())) continue;
            CodeEmitter e = context.beginMethod(ce, method);
            context.emitCallback(e, context.getIndex(method));
            if (this.proxyRef) {
                e.load_this();
                e.invoke_interface(PROXY_REF_DISPATCHER, PROXY_REF_LOAD_OBJECT);
            } else {
                e.invoke_interface(DISPATCHER, LOAD_OBJECT);
            }
            e.checkcast(method.getClassInfo().getType());
            e.load_args();
            e.invoke(method);
            e.return_value();
            e.end_method();
        }
    }

    @Override
    public void generateStatic(CodeEmitter e, CallbackGenerator.Context context, List<MethodInfo> methods) throws Exception {
    }
}

