/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.core.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.function.Function;

public class LoadingCache<K, KK, V> {
    protected final Function<K, V> loader;
    protected final Function<K, KK> keyMapper;
    protected final ConcurrentMap<KK, Object> map;

    public LoadingCache(Function<K, KK> keyMapper, Function<K, V> loader) {
        this.keyMapper = keyMapper;
        this.loader = loader;
        this.map = new ConcurrentHashMap<KK, Object>();
    }

    public V get(K key) {
        KK cacheKey = this.keyMapper.apply(key);
        Object v = this.map.get(cacheKey);
        if (v != null && !(v instanceof FutureTask)) {
            return v;
        }
        return this.createEntry(key, cacheKey, v);
    }

    protected V createEntry(K key, KK cacheKey, Object v) {
        Object result;
        FutureTask<Object> task;
        boolean creator = false;
        if (v != null) {
            task = (FutureTask<Object>)v;
        } else {
            task = new FutureTask<Object>(() -> this.loader.apply(key));
            FutureTask<Object> prevTask = this.map.putIfAbsent(cacheKey, task);
            if (prevTask == null) {
                creator = true;
                task.run();
            } else if (prevTask instanceof FutureTask) {
                task = prevTask;
            } else {
                return (V)prevTask;
            }
        }
        try {
            result = task.get();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted while loading cache item", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException("Unable to load cache item", cause);
        }
        if (creator) {
            this.map.put(cacheKey, result);
        }
        return result;
    }
}

