/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.cglib.core;

import cn.taketoday.context.asm.Type;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class Signature {
    private final String name;
    private final String desc;

    public Signature(Method method) {
        this(method.getName(), Type.getMethodDescriptor(method));
    }

    public Signature(Constructor<?> constructor) {
        this("<init>", Type.getConstructorDescriptor(constructor));
    }

    public Signature(String name, String desc) {
        if (name.indexOf(40) >= 0) {
            throw new IllegalArgumentException("Name '" + name + "' is invalid");
        }
        this.name = name;
        this.desc = desc;
    }

    public Signature(String name, Type returnType, Type[] argumentTypes) {
        this(name, Type.getMethodDescriptor(returnType, argumentTypes));
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.desc;
    }

    public Type getReturnType() {
        return Type.getReturnType(this.desc);
    }

    public Type[] getArgumentTypes() {
        return Type.getArgumentTypes(this.desc);
    }

    public String toString() {
        return this.name.concat(this.desc);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Signature) {
            Signature other = (Signature)o;
            return this.name.equals(other.name) && this.desc.equals(other.desc);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.desc.hashCode();
    }
}

