/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.aware;

import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.aware.ApplicationContextAware;
import cn.taketoday.context.exception.ContextException;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.utils.Assert;

public abstract class ApplicationContextSupport
implements ApplicationContextAware {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ApplicationContext applicationContext;

    @Override
    public final void setApplicationContext(ApplicationContext context) {
        if (this.applicationContext == null) {
            this.applicationContext = context;
            this.initApplicationContext(context);
        } else if (this.applicationContext != context) {
            throw new ContextException("Cannot reinitialize with different application context: current one is [" + this.applicationContext + "], passed-in one is [" + context + "]");
        }
    }

    protected void initApplicationContext(ApplicationContext context) {
        this.initApplicationContext();
    }

    protected void initApplicationContext() {
    }

    public final ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ApplicationContext obtainApplicationContext() {
        ApplicationContext context = this.getApplicationContext();
        Assert.state(context != null, "No ApplicationContext");
        return context;
    }
}

