/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context.annotation.condition;

import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.Condition;
import cn.taketoday.context.annotation.condition.ConditionalOnClass;
import cn.taketoday.context.annotation.condition.ConditionalOnMissingClass;
import cn.taketoday.context.utils.ClassUtils;
import java.lang.reflect.AnnotatedElement;

class OnClassCondition
implements Condition {
    OnClassCondition() {
    }

    @Override
    public boolean matches(ApplicationContext context, AnnotatedElement annotatedElement) {
        ConditionalOnMissingClass onMissingClass;
        ConditionalOnClass conditionalOnClass = annotatedElement.getAnnotation(ConditionalOnClass.class);
        if (conditionalOnClass != null) {
            for (String name : conditionalOnClass.value()) {
                if (ClassUtils.isPresent(name)) continue;
                return false;
            }
        }
        if ((onMissingClass = annotatedElement.getAnnotation(ConditionalOnMissingClass.class)) != null) {
            for (String name : onMissingClass.value()) {
                if (!ClassUtils.isPresent(name)) continue;
                return false;
            }
        }
        return true;
    }
}

