/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context;

import cn.taketoday.context.utils.ExceptionUtils;

public abstract class NestedRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public NestedRuntimeException() {
    }

    public NestedRuntimeException(String msg) {
        super(msg);
    }

    public NestedRuntimeException(Throwable cause) {
        super(cause);
    }

    public NestedRuntimeException(String msg, Throwable cause) {
        super(msg, cause);
    }

    @Override
    public String getMessage() {
        return this.buildMessage(super.getMessage());
    }

    protected String buildMessage(String message) {
        return ExceptionUtils.buildMessage(message, this.getCause());
    }

    public Throwable getRootCause() {
        return ExceptionUtils.getRootCause(this);
    }

    public Throwable getMostSpecificCause() {
        Throwable rootCause = this.getRootCause();
        return rootCause != null ? rootCause : this;
    }

    public boolean contains(Class<?> exType) {
        if (exType == null) {
            return false;
        }
        if (exType.isInstance(this)) {
            return true;
        }
        Throwable cause = this.getCause();
        if (cause == this) {
            return false;
        }
        if (cause instanceof NestedRuntimeException) {
            return ((NestedRuntimeException)cause).contains(exType);
        }
        while (cause != null) {
            if (exType.isInstance(cause)) {
                return true;
            }
            if (cause.getCause() == cause) break;
            cause = cause.getCause();
        }
        return false;
    }

    static {
        ExceptionUtils.class.getName();
    }
}

