/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context;

import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.annotation.Env;
import cn.taketoday.context.annotation.Value;
import cn.taketoday.context.conversion.ConversionService;
import cn.taketoday.context.conversion.support.DefaultConversionService;
import cn.taketoday.context.env.Environment;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.factory.ConfigurableBeanFactory;
import cn.taketoday.context.factory.ValueExpressionContext;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ContextUtils;
import cn.taketoday.context.utils.StringUtils;
import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.ExpressionException;
import cn.taketoday.expression.ExpressionFactory;
import cn.taketoday.expression.ExpressionManager;
import cn.taketoday.expression.ExpressionProcessor;
import cn.taketoday.expression.StandardExpressionContext;
import java.util.Map;
import java.util.Properties;

public class ExpressionEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ExpressionEvaluator.class);
    private ConversionService conversionService = DefaultConversionService.getSharedInstance();
    private ExpressionProcessor expressionProcessor;
    private Properties variables;
    private boolean throwIfPropertyNotFound = false;
    private ApplicationContext context;

    public ExpressionEvaluator() {
        this(System.getProperties());
    }

    public ExpressionEvaluator(Properties variables) {
        this.setVariables(variables);
    }

    public ExpressionEvaluator(ExpressionProcessor expressionProcessor) {
        this(expressionProcessor, System.getProperties());
    }

    public ExpressionEvaluator(ExpressionProcessor expressionProcessor, Properties variables) {
        this(variables);
        Assert.notNull((Object)expressionProcessor, "ExpressionProcessor must not be null");
        this.expressionProcessor = expressionProcessor;
    }

    public ExpressionEvaluator(ApplicationContext context) {
        this(context, context.getBean(ExpressionProcessor.class));
    }

    public ExpressionEvaluator(ApplicationContext context, ExpressionProcessor expressionProcessor) {
        Assert.notNull((Object)context, "ApplicationContext must not be null");
        this.context = context;
        Environment environment = context.getEnvironment();
        this.variables = environment.getProperties();
        this.expressionProcessor = expressionProcessor != null ? expressionProcessor : environment.getExpressionProcessor();
    }

    public Object evaluate(String expression) {
        return this.expressionProcessor.eval(expression);
    }

    public <T> T evaluate(String expression, Class<T> expectedType) {
        return this.evaluate(expression, expectedType, this.variables);
    }

    public <T> T evaluate(String expression, Class<T> expectedType, Map<Object, Object> variables) {
        if (expression.contains("#{")) {
            String replaced = this.resolvePlaceholder(variables, expression);
            return this.conversionService.convert((Object)replaced, expectedType);
        }
        if (expression.contains("${")) {
            try {
                return this.obtainProcessor().getValue(expression, expectedType);
            }
            catch (ExpressionException e) {
                throw new ConfigurationException(e);
            }
        }
        return this.conversionService.convert((Object)expression, expectedType);
    }

    public <T> T evaluate(String expression, ExpressionContext context, Class<T> expectedType) {
        if (expression.contains("#{")) {
            String replaced = this.resolvePlaceholder(this.variables, expression);
            return this.conversionService.convert((Object)replaced, expectedType);
        }
        if (expression.contains("${")) {
            try {
                return this.obtainProcessor().getValue(expression, context, expectedType);
            }
            catch (ExpressionException e) {
                throw new ConfigurationException(e);
            }
        }
        return this.conversionService.convert((Object)expression, expectedType);
    }

    public <T> T evaluate(Env value, Class<T> expectedType) {
        T resolveValue = this.evaluate("#{" + value.value() + '}', expectedType);
        if (resolveValue != null) {
            return resolveValue;
        }
        if (value.required()) {
            throw new ConfigurationException("Can't resolve property: [" + value.value() + "]");
        }
        String defaultValue = value.defaultValue();
        if (StringUtils.isEmpty(defaultValue)) {
            return null;
        }
        return this.evaluate(defaultValue, expectedType);
    }

    public <T> T evaluate(Value value, Class<T> expectedType) {
        T resolveValue = this.evaluate(value.value(), expectedType);
        if (resolveValue != null) {
            return resolveValue;
        }
        if (value.required()) {
            throw new ConfigurationException("Can't resolve expression: [" + value.value() + "]");
        }
        String defaultValue = value.defaultValue();
        if (StringUtils.isEmpty(defaultValue)) {
            return null;
        }
        return this.evaluate(defaultValue, expectedType);
    }

    public String resolvePlaceholder(Map<Object, Object> properties, String input) {
        return this.resolvePlaceholder(properties, input, this.throwIfPropertyNotFound);
    }

    public String resolvePlaceholder(Map<Object, Object> properties, String input, boolean throwIfPropertyNotFound) {
        int suffixIndex;
        int prefixIndex;
        if (input == null || input.length() <= 3) {
            return input;
        }
        StringBuilder builder = new StringBuilder();
        while ((prefixIndex = input.indexOf("#{")) > -1 && (suffixIndex = input.indexOf(125)) > -1) {
            builder.append(input, 0, prefixIndex);
            String key = input.substring(prefixIndex + 2, suffixIndex);
            Object property = properties.get(key);
            if (property == null) {
                if (throwIfPropertyNotFound) {
                    throw new ConfigurationException("Properties -> [" + key + "] , must specify a value.");
                }
                log.debug("There is no property for key: [{}]", (Object)key);
                return null;
            }
            builder.append(this.resolvePlaceholder(properties, property instanceof String ? (String)property : null, throwIfPropertyNotFound));
            input = input.substring(suffixIndex + 1);
        }
        if (builder.length() == 0) {
            return input;
        }
        return builder.append(input).toString();
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setThrowIfPropertyNotFound(boolean throwIfPropertyNotFound) {
        this.throwIfPropertyNotFound = throwIfPropertyNotFound;
    }

    public Properties getVariables() {
        return this.variables;
    }

    public void setVariables(Properties variables) {
        Assert.notNull((Object)variables, "variables must not be null");
        this.variables = variables;
    }

    public void setExpressionProcessor(ExpressionProcessor expressionProcessor) {
        this.expressionProcessor = expressionProcessor;
    }

    public ExpressionProcessor getExpressionProcessor() {
        return this.expressionProcessor;
    }

    public void setContext(ApplicationContext context) {
        this.context = context;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    private ExpressionProcessor obtainProcessor() {
        if (this.expressionProcessor == null) {
            StandardExpressionContext globalContext;
            ExpressionFactory exprFactory = ExpressionFactory.getSharedInstance();
            ApplicationContext context = this.context;
            if (context == null) {
                context = ContextUtils.getLastStartupContext();
                if (context == null) {
                    log.info("There isn't a global ApplicationContext");
                } else {
                    log.info("Using global ApplicationContext {}", (Object)context);
                }
            }
            if (context == null) {
                globalContext = new StandardExpressionContext(exprFactory);
            } else {
                BeanFactory beanFactory = context.getBeanFactory();
                globalContext = new ValueExpressionContext(exprFactory, (ConfigurableBeanFactory)beanFactory);
            }
            globalContext.defineBean("env", this.variables);
            this.expressionProcessor = new ExpressionProcessor(new ExpressionManager(globalContext, exprFactory));
        }
        return this.expressionProcessor;
    }
}

