/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class ConcurrentProperties
extends Properties
implements ConcurrentMap<Object, Object> {
    private final ConcurrentHashMap<Object, Object> map = new ConcurrentHashMap();

    public ConcurrentProperties() {
    }

    public ConcurrentProperties(Properties defaults) {
        super(defaults);
    }

    @Override
    public String getProperty(String key) {
        Object oval = this.map.get(key);
        String sval = oval instanceof String ? (String)oval : null;
        return sval == null && this.defaults != null ? this.defaults.getProperty(key) : sval;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        return val == null ? defaultValue : val;
    }

    @Override
    public Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    @Override
    public Enumeration<Object> keys() {
        return Collections.enumeration(this.keySet());
    }

    @Override
    public Enumeration<Object> elements() {
        return Collections.enumeration(this.values());
    }

    @Override
    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Object put(Object key, Object value) {
        if (key == null || value == null) {
            return null;
        }
        return this.map.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<Object> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        return this.map.putIfAbsent(key, value);
    }

    @Override
    public Object computeIfAbsent(Object key, Function<? super Object, ? extends Object> mappingFunction) {
        return this.map.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public Object compute(Object key, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        return this.map.compute(key, remappingFunction);
    }

    @Override
    public Object computeIfPresent(Object key, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        return this.map.computeIfPresent(key, remappingFunction);
    }

    @Override
    protected void rehash() {
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        return this.map.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super Object, ? super Object> action) {
        this.map.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super Object, ? super Object, ? extends Object> function) {
        this.map.replaceAll(function);
    }

    @Override
    public Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        return this.map.merge(key, value, remappingFunction);
    }

    @Override
    public Enumeration<?> propertyNames() {
        return this.keys();
    }

    @Override
    public Set<String> stringPropertyNames() {
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            Object k = entry.getKey();
            if (!(k instanceof String) || !(entry.getValue() instanceof String)) continue;
            keys.add((String)k);
        }
        return keys;
    }

    @Override
    public ConcurrentProperties clone() {
        ConcurrentProperties ret = new ConcurrentProperties();
        ret.putAll((Map<? extends Object, ? extends Object>)this.map);
        return ret;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.map.remove(key, value);
    }

    @Override
    public Object replace(Object key, Object value) {
        return this.map.replace(key, value);
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        return this.map.replace(key, oldValue, newValue);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public void list(PrintStream out) {
        PrintWriter printWriter = new PrintWriter(out);
        this.list(printWriter);
        printWriter.flush();
    }

    @Override
    public void list(PrintWriter out) {
        out.println("-- listing properties --");
        for (Map.Entry<Object, Object> entry : this.map.entrySet()) {
            out.println(entry.getKey() + " = " + entry.getValue());
        }
    }
}

