/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context;

import cn.taketoday.context.utils.ClassUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;

public interface AnnotationSupport
extends AnnotatedElement {
    public AnnotatedElement getAnnotationSource();

    @Override
    default public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return ClassUtils.isAnnotationPresent(this.getAnnotationSource(), annotationClass);
    }

    default public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return ClassUtils.getAnnotation(annotationClass, this.getAnnotationSource());
    }

    @Override
    default public Annotation[] getAnnotations() {
        return this.getAnnotationSource().getAnnotations();
    }

    @Override
    default public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotationSource().getDeclaredAnnotations();
    }

    @Override
    default public <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        return this.getAnnotationSource().getDeclaredAnnotation(annotationClass);
    }

    @Override
    default public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        return this.getAnnotationSource().getAnnotationsByType(annotationClass);
    }

    @Override
    default public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        return this.getAnnotationSource().getDeclaredAnnotationsByType(annotationClass);
    }
}

