/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.context;

import cn.taketoday.context.ApplicationContext;
import cn.taketoday.context.BeanNameCreator;
import cn.taketoday.context.ConfigurableApplicationContext;
import cn.taketoday.context.Scope;
import cn.taketoday.context.env.ConfigurableEnvironment;
import cn.taketoday.context.env.Environment;
import cn.taketoday.context.event.ApplicationEventCapable;
import cn.taketoday.context.event.ApplicationListener;
import cn.taketoday.context.event.BeanDefinitionLoadedEvent;
import cn.taketoday.context.event.BeanDefinitionLoadingEvent;
import cn.taketoday.context.event.ContextCloseEvent;
import cn.taketoday.context.event.ContextCloseListener;
import cn.taketoday.context.event.ContextPreRefreshEvent;
import cn.taketoday.context.event.ContextRefreshEvent;
import cn.taketoday.context.event.ContextStartedEvent;
import cn.taketoday.context.event.DependenciesHandledEvent;
import cn.taketoday.context.event.EventListener;
import cn.taketoday.context.event.ObjectRefreshedEvent;
import cn.taketoday.context.exception.BeanInitializingException;
import cn.taketoday.context.exception.ConfigurationException;
import cn.taketoday.context.exception.ContextException;
import cn.taketoday.context.exception.NoSuchBeanDefinitionException;
import cn.taketoday.context.factory.AbstractBeanFactory;
import cn.taketoday.context.factory.BeanDefinition;
import cn.taketoday.context.factory.BeanFactory;
import cn.taketoday.context.factory.BeanFactoryPostProcessor;
import cn.taketoday.context.factory.BeanPostProcessor;
import cn.taketoday.context.factory.BeanReferencePropertySetter;
import cn.taketoday.context.factory.ObjectSupplier;
import cn.taketoday.context.factory.ValueExpressionContext;
import cn.taketoday.context.loader.CandidateComponentScanner;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.CollectionUtils;
import cn.taketoday.context.utils.ContextUtils;
import cn.taketoday.context.utils.ExceptionUtils;
import cn.taketoday.context.utils.GenericTypeResolver;
import cn.taketoday.context.utils.ObjectUtils;
import cn.taketoday.context.utils.OrderUtils;
import cn.taketoday.context.utils.StringUtils;
import cn.taketoday.expression.ExpressionFactory;
import cn.taketoday.expression.ExpressionManager;
import cn.taketoday.expression.ExpressionProcessor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractApplicationContext
implements ConfigurableApplicationContext {
    private static final Logger log = LoggerFactory.getLogger(AbstractApplicationContext.class);
    private long startupDate;
    private final ConfigurableEnvironment environment;
    private ApplicationContext.State state;
    private final HashMap<Class<?>, List<ApplicationListener<Object>>> applicationListeners = new HashMap(32);
    private String[] locations;
    private CandidateComponentScanner candidateComponentScanner;
    private LinkedList<BeanFactoryPostProcessor> factoryPostProcessors;

    public AbstractApplicationContext(ConfigurableEnvironment env) {
        this.applyState(ApplicationContext.State.NONE);
        this.environment = env;
        ContextUtils.setLastStartupContext(this);
        this.checkEnvironment(env);
    }

    public void load() {
        this.load("");
    }

    @Override
    public void load(Collection<Class<?>> candidates) {
        HashSet candidateSet = candidates instanceof Set ? (HashSet)candidates : new HashSet(candidates);
        this.getCandidateComponentScanner().setCandidates(candidateSet);
        this.load((String[])null);
    }

    @Override
    public void load(String ... locations) {
        this.locations = locations;
        try {
            this.prepareRefresh();
            this.prepareBeanFactory();
            this.preRefresh();
            this.refresh();
            this.finishRefresh();
        }
        catch (Throwable ex) {
            this.close();
            this.applyState(ApplicationContext.State.FAILED);
            ex = ExceptionUtils.unwrapThrowable(ex);
            throw new ContextException("An Exception Occurred When Loading Context", ex);
        }
    }

    protected void prepareRefresh() {
        this.startupDate = System.currentTimeMillis();
        log.info("Starting Application Context at [{}].", (Object)this.formatStartupDate());
        this.applyState(ApplicationContext.State.STARTING);
        ConfigurableEnvironment env = this.getEnvironment();
        try {
            env.loadProperties();
        }
        catch (IOException ex) {
            throw new ContextException("An Exception Occurred When Loading Properties", ex);
        }
        this.postProcessLoadProperties(env);
        if (env.getFlag("enable.full.prototype")) {
            this.enableFullPrototype();
        }
        if (env.getFlag("enable.full.lifecycle")) {
            this.enableFullLifecycle();
        }
    }

    protected void postProcessLoadProperties(ConfigurableEnvironment environment) {
        ClassUtils.setEnableParamNameTypeChecking(environment.getFlag("ClassUtils.enableParamNameTypeChecking", false));
    }

    protected void loadBeanDefinitions(AbstractBeanFactory beanFactory, Collection<Class<?>> candidates) {
        beanFactory.getBeanDefinitionLoader().loadBeanDefinitions(candidates);
    }

    protected void finishRefresh() {
        this.publishEvent(new ContextStartedEvent(this));
        this.applyState(ApplicationContext.State.STARTED);
        log.info("Application Context Startup in {}ms", (Object)(System.currentTimeMillis() - this.getStartupDate()));
    }

    protected void preRefresh() {
        this.publishEvent(new ContextPreRefreshEvent(this));
        this.getBeanFactory().preInitialization();
    }

    public void prepareBeanFactory() {
        AbstractBeanFactory beanFactory = this.getBeanFactory();
        ConfigurableEnvironment env = this.getEnvironment();
        this.checkEnvironment(env);
        log.info("Registering framework beans");
        this.registerFrameworkBeans(env, beanFactory.getBeanNameCreator());
        log.info("Loading candidates components");
        Set<Class<?>> candidates = this.getComponentCandidates();
        log.info("There are [{}] candidates components in [{}]", (Object)candidates.size(), (Object)this);
        this.registerListener(candidates, this.applicationListeners);
        this.publishEvent(new BeanDefinitionLoadingEvent(this, candidates));
        this.loadBeanDefinitions(beanFactory, candidates);
        this.publishEvent(new BeanDefinitionLoadedEvent(this, beanFactory.getBeanDefinitions()));
        beanFactory.handleDependency();
        this.publishEvent(new DependenciesHandledEvent(this, beanFactory.getDependencies()));
        this.postProcessBeanFactory(beanFactory);
    }

    protected void checkEnvironment(ConfigurableEnvironment env) {
        if (env.getBeanDefinitionRegistry() == null) {
            env.setBeanDefinitionRegistry(this.getBeanFactory());
        }
        if (env.getBeanDefinitionLoader() == null) {
            env.setBeanDefinitionLoader(this.getBeanFactory().getBeanDefinitionLoader());
        }
        if (env.getExpressionProcessor() == null) {
            ExpressionFactory exprFactory = ExpressionFactory.getSharedInstance();
            ValueExpressionContext elContext = new ValueExpressionContext(exprFactory, this.getBeanFactory());
            elContext.defineBean("env", env.getProperties());
            env.setExpressionProcessor(new ExpressionProcessor(new ExpressionManager(elContext, exprFactory)));
        }
    }

    protected Set<Class<?>> getComponentCandidates() {
        CandidateComponentScanner scanner = this.getCandidateComponentScanner();
        if (ObjectUtils.isEmpty(this.locations)) {
            if (scanner.getCandidates() == null) {
                return scanner.scan();
            }
            return scanner.getScanningCandidates();
        }
        return scanner.scan(this.locations);
    }

    public void registerFrameworkBeans() {
        this.registerFrameworkBeans(this.getEnvironment(), this.getBeanFactory().getBeanNameCreator());
    }

    protected void registerFrameworkBeans(ConfigurableEnvironment env, BeanNameCreator beanNameCreator) {
        ExpressionProcessor elProcessor = env.getExpressionProcessor();
        this.registerSingleton(beanNameCreator.create(ExpressionManager.class), elProcessor.getManager());
        this.registerSingleton(beanNameCreator.create(ExpressionProcessor.class), elProcessor);
        this.registerSingleton(beanNameCreator.create(Environment.class), env);
        this.registerSingleton(beanNameCreator.create(ApplicationContext.class), this);
        this.registerSingleton(beanNameCreator.create(BeanFactory.class), this.getBeanFactory());
    }

    protected void postProcessBeanFactory(AbstractBeanFactory beanFactory) {
        this.registerBeanFactoryPostProcessor();
        if (!CollectionUtils.isEmpty(this.factoryPostProcessors)) {
            for (BeanFactoryPostProcessor postProcessor : this.factoryPostProcessors) {
                postProcessor.postProcessBeanFactory(beanFactory);
            }
        }
        beanFactory.registerBeanPostProcessors();
        if (beanFactory.isFullPrototype()) {
            for (BeanReferencePropertySetter reference : beanFactory.getDependencies()) {
                BeanDefinition def = beanFactory.getBeanDefinition(reference.getReferenceName());
                if (def == null || !def.isPrototype()) continue;
                reference.applyPrototype();
            }
        }
    }

    public void registerBeanFactoryPostProcessor() {
        log.info("Loading BeanFactoryPostProcessor.");
        List<BeanFactoryPostProcessor> postProcessors = this.getBeans(BeanFactoryPostProcessor.class);
        if (!postProcessors.isEmpty()) {
            this.getFactoryPostProcessors().addAll(postProcessors);
            OrderUtils.reversedSort(this.factoryPostProcessors);
        }
    }

    void registerListener(Collection<Class<?>> candidates, Map<Class<?>, List<ApplicationListener<Object>>> applicationListeners) {
        log.info("Loading Application Listeners.");
        for (Class<?> candidateListener : candidates) {
            if (!ClassUtils.isAnnotationPresent(candidateListener, EventListener.class)) continue;
            this.registerListener(candidateListener);
        }
        this.postProcessRegisterListener(applicationListeners);
    }

    protected void registerListener(Class<?> listenerClass) {
        if (!ApplicationListener.class.isAssignableFrom(listenerClass)) {
            throw new ConfigurationException("@EventListener must be a 'ApplicationListener'");
        }
        try {
            Object applicationListener = this.getSingleton(listenerClass);
            if (applicationListener == null) {
                applicationListener = ClassUtils.newInstance(listenerClass, (BeanFactory)this);
                this.registerSingleton(applicationListener);
            }
            this.addApplicationListener((ApplicationListener)applicationListener);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new ConfigurationException("It is best not to use constructor-injection when instantiating the listener", e);
        }
        catch (Throwable ex) {
            ex = ExceptionUtils.unwrapThrowable(ex);
            throw new ContextException("An Exception Occurred When Register Application Listener", ex);
        }
    }

    @Override
    public void addApplicationListener(ApplicationListener<?> listener) {
        Assert.notNull(listener, "listener can't be null");
        HashMap<Class<?>, List<ApplicationListener<Object>>> listeners = this.applicationListeners;
        if (listener instanceof ApplicationEventCapable) {
            for (Class<?> type : ((ApplicationEventCapable)((Object)listener)).getApplicationEvent()) {
                this.addApplicationListener(listener, type, listeners);
            }
        } else {
            Class eventType = GenericTypeResolver.resolveTypeArgument(listener.getClass(), ApplicationListener.class);
            this.addApplicationListener(listener, eventType, listeners);
        }
    }

    void addApplicationListener(ApplicationListener<?> applicationListener, Class<?> eventType, Map<Class<?>, List<ApplicationListener<Object>>> applicationListeners) {
        List<ApplicationListener<Object>> listeners = applicationListeners.get(eventType);
        if (listeners == null) {
            listeners = new ArrayList<ApplicationListener<Object>>(2);
            applicationListeners.put(eventType, listeners);
            listeners.add(applicationListener);
        } else if (!listeners.contains(applicationListener)) {
            listeners.add(applicationListener);
            if (!listeners.isEmpty()) {
                OrderUtils.reversedSort(listeners);
            }
        }
    }

    protected void postProcessRegisterListener(Map<Class<?>, List<ApplicationListener<Object>>> applicationListeners) {
        this.addApplicationListener(new ContextCloseListener());
        for (Class<?> listener : this.loadMetaInfoListeners()) {
            this.registerListener(listener);
        }
    }

    public Set<Class<?>> loadMetaInfoListeners() {
        log.info("Loading META-INF/listeners");
        return ContextUtils.loadFromMetaInfo("META-INF/listeners");
    }

    @Override
    public void refresh() {
        try {
            this.publishEvent(new ContextRefreshEvent(this));
            this.initializeSingletons();
        }
        catch (Throwable ex) {
            ex = ExceptionUtils.unwrapThrowable(ex);
            throw new ContextException("An Exception Occurred When Refresh Context: [" + this + "]", ex);
        }
    }

    @Override
    public void close() {
        this.applyState(ApplicationContext.State.CLOSING);
        this.publishEvent(new ContextCloseEvent(this));
        this.applyState(ApplicationContext.State.CLOSED);
    }

    @Override
    public void publishEvent(Object event) {
        List<ApplicationListener<Object>> listeners;
        if (log.isDebugEnabled()) {
            log.debug("Publish event: [{}]", event);
        }
        if (CollectionUtils.isEmpty(listeners = this.applicationListeners.get(event.getClass()))) {
            return;
        }
        for (ApplicationListener<Object> applicationListener : listeners) {
            applicationListener.onApplicationEvent(event);
        }
    }

    @Override
    public abstract AbstractBeanFactory getBeanFactory();

    @Override
    public ConfigurableEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public boolean hasStarted() {
        return this.state == ApplicationContext.State.STARTED;
    }

    @Override
    public ApplicationContext.State getState() {
        return this.state;
    }

    protected void applyState(ApplicationContext.State state) {
        this.state = state;
    }

    @Override
    public long getStartupDate() {
        return this.startupDate;
    }

    @Override
    public void registerBean(String name, BeanDefinition beanDefinition) {
        this.getBeanFactory().registerBean(name, beanDefinition);
    }

    @Override
    public void removeBean(String name) {
        this.getBeanFactory().removeBean(name);
    }

    @Override
    public void registerBean(String name, Class<?> clazz) {
        this.getBeanFactory().registerBean(name, clazz);
    }

    @Override
    public void registerBean(Class<?> clazz) {
        this.getBeanFactory().registerBean(clazz);
    }

    @Override
    public void registerBean(Set<Class<?>> clazz) {
        this.getBeanFactory().registerBean(clazz);
    }

    @Override
    public void registerBean(Object obj) {
        this.getBeanFactory().registerBean(obj);
    }

    @Override
    public void registerBean(String name, Object obj) {
        this.getBeanFactory().registerBean(name, obj);
    }

    @Override
    public void destroyBean(String name) {
        this.getBeanFactory().destroyBean(name);
    }

    @Override
    public void destroyBean(String beanName, Object beanInstance) {
        this.getBeanFactory().destroyBean(beanName, beanInstance);
    }

    @Override
    public void destroyScopedBean(String beanName) {
        this.getBeanFactory().destroyScopedBean(beanName);
    }

    @Override
    public void refresh(String name) {
        this.getBeanFactory().refresh(name);
        this.publishEvent(new ObjectRefreshedEvent(this.getBeanDefinition(name), (ApplicationContext)this));
    }

    @Override
    public Object refresh(BeanDefinition def) {
        Object initializingBean = this.getBeanFactory().refresh(def);
        this.publishEvent(new ObjectRefreshedEvent(def, (ApplicationContext)this));
        return initializingBean;
    }

    @Override
    public void initializeSingletons() {
        this.getBeanFactory().initializeSingletons();
    }

    @Override
    public void addBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        this.getBeanFactory().addBeanPostProcessor(beanPostProcessor);
    }

    @Override
    public void addBeanFactoryPostProcessor(BeanFactoryPostProcessor postProcessor) {
        Assert.notNull((Object)postProcessor, "BeanFactoryPostProcessor must not be null");
        this.getFactoryPostProcessors().add(postProcessor);
    }

    @Override
    public void removeBeanPostProcessor(BeanPostProcessor beanPostProcessor) {
        this.getBeanFactory().removeBeanPostProcessor(beanPostProcessor);
    }

    @Override
    public Object getBean(String name) {
        return this.getBeanFactory().getBean(name);
    }

    @Override
    public Object getBean(BeanDefinition def) {
        return this.getBeanFactory().getBean(def);
    }

    @Override
    public <T> T getBean(Class<T> requiredType) {
        return this.getBeanFactory().getBean(requiredType);
    }

    @Override
    public <T> T getBean(String name, Class<T> requiredType) {
        return this.getBeanFactory().getBean(name, requiredType);
    }

    @Override
    public <T> ObjectSupplier<T> getBeanSupplier(BeanDefinition def) {
        return this.getBeanFactory().getBeanSupplier(def);
    }

    @Override
    public <T> ObjectSupplier<T> getBeanSupplier(Class<T> requiredType) {
        return this.getBeanFactory().getBeanSupplier(requiredType);
    }

    @Override
    public Object getScopeBean(BeanDefinition def, Scope scope) {
        return this.getBeanFactory().getScopeBean(def, scope);
    }

    @Override
    public <T> List<T> getBeans(Class<T> requiredType) {
        return this.getBeanFactory().getBeans(requiredType);
    }

    @Override
    public <A extends Annotation> A getAnnotationOnBean(String beanName, Class<A> annotationType) {
        return this.getBeanFactory().getAnnotationOnBean(beanName, annotationType);
    }

    @Override
    public <T> List<T> getAnnotatedBeans(Class<? extends Annotation> annotationType) {
        return this.getBeanFactory().getAnnotatedBeans(annotationType);
    }

    @Override
    public Set<String> getBeanNamesOfType(Class<?> requiredType, boolean includeNonSingletons) {
        return this.getBeanFactory().getBeanNamesOfType(requiredType, includeNonSingletons);
    }

    @Override
    public Set<String> getBeanNamesOfType(Class<?> requiredType, boolean includeNoneRegistered, boolean includeNonSingletons) {
        return this.getBeanFactory().getBeanNamesOfType(requiredType, includeNoneRegistered, includeNonSingletons);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(Class<T> requiredType) {
        return this.getBeanFactory().getBeansOfType(requiredType);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(Class<T> requiredType, boolean includeNonSingletons) {
        return this.getBeanFactory().getBeansOfType(requiredType, includeNonSingletons);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(Class<T> requiredType, boolean includeNoneRegistered, boolean includeNonSingletons) {
        return this.getBeanFactory().getBeansOfType(requiredType, includeNoneRegistered, includeNonSingletons);
    }

    @Override
    public Map<String, Object> getBeansOfAnnotation(Class<? extends Annotation> annotationType) {
        return this.getBeanFactory().getBeansOfAnnotation(annotationType);
    }

    @Override
    public Map<String, Object> getBeansOfAnnotation(Class<? extends Annotation> annotationType, boolean includeNonSingletons) {
        return this.getBeanFactory().getBeansOfAnnotation(annotationType, includeNonSingletons);
    }

    @Override
    public Map<String, BeanDefinition> getBeanDefinitions() {
        return this.getBeanFactory().getBeanDefinitions();
    }

    @Override
    public boolean isSingleton(String name) {
        return this.getBeanFactory().isSingleton(name);
    }

    @Override
    public boolean isPrototype(String name) {
        return this.getBeanFactory().isPrototype(name);
    }

    @Override
    public Class<?> getType(String name) {
        return this.getBeanFactory().getType(name);
    }

    @Override
    public Set<String> getAliases(Class<?> type) {
        return this.getBeanFactory().getAliases(type);
    }

    @Override
    public String getBeanName(Class<?> targetClass) {
        return this.getBeanFactory().getBeanName(targetClass);
    }

    @Override
    public void registerSingleton(String name, Object bean) {
        this.getBeanFactory().registerSingleton(name, bean);
    }

    @Override
    public void registerSingleton(Object bean) {
        this.getBeanFactory().registerSingleton(bean);
    }

    @Override
    public Map<String, Object> getSingletons() {
        return this.getBeanFactory().getSingletons();
    }

    @Override
    public Object getSingleton(String name) {
        return this.getBeanFactory().getSingleton(name);
    }

    @Override
    public <T> T getSingleton(Class<T> requiredType) {
        return this.getBeanFactory().getSingleton(requiredType);
    }

    @Override
    public void removeSingleton(String name) {
        this.getBeanFactory().removeSingleton(name);
    }

    @Override
    public boolean containsSingleton(String name) {
        return this.getBeanFactory().containsSingleton(name);
    }

    @Override
    public void registerBeanDefinition(String name, BeanDefinition beanDefinition) {
        this.getBeanFactory().registerBeanDefinition(name, beanDefinition);
    }

    @Override
    public void removeBeanDefinition(String beanName) {
        this.getBeanFactory().removeBeanDefinition(beanName);
    }

    @Override
    public BeanDefinition getBeanDefinition(String beanName) {
        return this.getBeanFactory().getBeanDefinition(beanName);
    }

    @Override
    public BeanDefinition getBeanDefinition(Class<?> beanClass) {
        return this.getBeanFactory().getBeanDefinition(beanClass);
    }

    @Override
    public boolean containsBeanDefinition(String beanName) {
        return this.getBeanFactory().containsBeanDefinition(beanName);
    }

    @Override
    public boolean containsBeanDefinition(Class<?> type) {
        return this.getBeanFactory().containsBeanDefinition(type);
    }

    @Override
    public boolean containsBeanDefinition(Class<?> type, boolean equals) {
        return this.getBeanFactory().containsBeanDefinition(type, equals);
    }

    @Override
    public Set<String> getBeanDefinitionNames() {
        return this.getBeanFactory().getBeanDefinitionNames();
    }

    @Override
    public int getBeanDefinitionCount() {
        return this.getBeanFactory().getBeanDefinitionCount();
    }

    @Override
    public void enableFullPrototype() {
        this.getBeanFactory().enableFullPrototype();
    }

    @Override
    public void enableFullLifecycle() {
        this.getBeanFactory().enableFullLifecycle();
    }

    @Override
    public boolean isFullLifecycle() {
        return this.getBeanFactory().isFullLifecycle();
    }

    @Override
    public boolean isFullPrototype() {
        return this.getBeanFactory().isFullPrototype();
    }

    @Override
    public void setFullLifecycle(boolean fullLifecycle) {
        this.getBeanFactory().setFullLifecycle(fullLifecycle);
    }

    @Override
    public void setFullPrototype(boolean fullPrototype) {
        this.getBeanFactory().setFullPrototype(fullPrototype);
    }

    @Override
    public <T> T createBean(Class<T> beanClass, boolean cacheBeanDef) {
        return this.getBeanFactory().createBean(beanClass, cacheBeanDef);
    }

    @Override
    public void autowireBean(Object existingBean) {
        this.getBeanFactory().autowireBean(existingBean);
    }

    @Override
    public void autowireBeanProperties(Object existingBean) {
        this.getBeanFactory().autowireBeanProperties(existingBean);
    }

    @Override
    public Object initializeBean(Object existingBean) throws BeanInitializingException {
        return this.getBeanFactory().initializeBean(existingBean);
    }

    @Override
    public Object initializeBean(Object existingBean, String beanName) {
        return this.getBeanFactory().initializeBean(existingBean, beanName);
    }

    @Override
    public Object initializeBean(Object existingBean, BeanDefinition def) {
        return this.getBeanFactory().initializeBean(existingBean, def);
    }

    @Override
    public Object applyBeanPostProcessorsAfterInitialization(Object existingBean, String beanName) {
        return this.getBeanFactory().applyBeanPostProcessorsAfterInitialization(existingBean, beanName);
    }

    @Override
    public Object applyBeanPostProcessorsBeforeInitialization(Object existingBean, String beanName) {
        return this.getBeanFactory().applyBeanPostProcessorsBeforeInitialization(existingBean, beanName);
    }

    @Override
    public void destroyBean(Object existingBean) {
        this.getBeanFactory().destroyBean(existingBean);
    }

    @Override
    public void destroyBean(Object beanInstance, BeanDefinition def) {
        this.getBeanFactory().destroyBean(beanInstance, def);
    }

    @Override
    public void importBeans(Class<?> ... beans) {
        this.getBeanFactory().importBeans(beans);
    }

    @Override
    public void importAnnotated(BeanDefinition annotated) {
        this.getBeanFactory().importAnnotated(annotated);
    }

    @Override
    public void importBeans(Set<BeanDefinition> defs) {
        this.getBeanFactory().importBeans(defs);
    }

    public void setPropertiesLocation(String propertiesLocation) {
        if (StringUtils.isNotEmpty(propertiesLocation)) {
            this.getEnvironment().setPropertiesLocation(propertiesLocation);
        }
    }

    @Override
    public CandidateComponentScanner getCandidateComponentScanner() {
        CandidateComponentScanner ret = this.candidateComponentScanner;
        if (ret == null) {
            this.candidateComponentScanner = this.createCandidateComponentScanner();
            return this.candidateComponentScanner;
        }
        return ret;
    }

    protected CandidateComponentScanner createCandidateComponentScanner() {
        return CandidateComponentScanner.getSharedInstance();
    }

    @Override
    public void setCandidateComponentScanner(CandidateComponentScanner candidateComponentScanner) {
        this.candidateComponentScanner = candidateComponentScanner;
    }

    public final List<BeanFactoryPostProcessor> getFactoryPostProcessors() {
        LinkedList<BeanFactoryPostProcessor> processors = this.factoryPostProcessors;
        if (processors == null) {
            this.factoryPostProcessors = new LinkedList<BeanFactoryPostProcessor>();
            return this.factoryPostProcessors;
        }
        return processors;
    }

    @Override
    public void registerScope(String name, Scope scope) {
        this.getBeanFactory().registerScope(name, scope);
    }

    public String toString() {
        return ObjectUtils.toHexString(this) + ": state: [" + (Object)((Object)this.state) + "], on startup date: " + this.formatStartupDate();
    }

    public String formatStartupDate() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(this.startupDate);
    }
}

