/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache.interceptor;

import cn.taketoday.cache.CacheExpressionContext;
import cn.taketoday.cache.CacheManager;
import cn.taketoday.cache.annotation.CacheConfiguration;
import cn.taketoday.cache.annotation.CachePut;
import cn.taketoday.cache.interceptor.AbstractCacheInterceptor;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;

public class CachePutInterceptor
extends AbstractCacheInterceptor {
    public CachePutInterceptor() {
        this.setOrder(0x7FFFFFFE);
    }

    public CachePutInterceptor(CacheManager cacheManager) {
        this();
        this.setCacheManager(cacheManager);
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result = invocation.proceed();
        Method method = invocation.getMethod();
        AbstractCacheInterceptor.MethodKey methodKey = new AbstractCacheInterceptor.MethodKey(method, CachePut.class);
        CacheConfiguration cachePut = AbstractCacheInterceptor.Operations.prepareAnnotation(methodKey);
        CacheExpressionContext context = AbstractCacheInterceptor.Operations.prepareELContext(methodKey, invocation);
        context.putBean("result", result);
        if (AbstractCacheInterceptor.Operations.isConditionPassing(cachePut.condition(), context)) {
            Object key = AbstractCacheInterceptor.Operations.createKey(cachePut.key(), context, invocation);
            this.put(this.obtainCache(method, cachePut), key, result);
        }
        return result;
    }
}

