/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache.interceptor;

import cn.taketoday.cache.Cache;
import cn.taketoday.cache.CacheCallback;
import cn.taketoday.cache.interceptor.CacheExceptionResolver;

public class CacheOperations {
    private CacheExceptionResolver exceptionResolver;

    public CacheOperations() {
    }

    public CacheOperations(CacheExceptionResolver exceptionResolver) {
        this.exceptionResolver = exceptionResolver;
    }

    public Object get(Cache cache, Object key) {
        try {
            return cache.get(key);
        }
        catch (RuntimeException ex) {
            this.getExceptionResolver().resolveGetException(ex, cache, key);
            return null;
        }
    }

    public Object get(Cache cache, Object key, CacheCallback<Object> valueLoader) {
        try {
            return cache.get(key, valueLoader);
        }
        catch (RuntimeException ex) {
            return this.getExceptionResolver().resolveGetException(ex, cache, key);
        }
    }

    public void put(Cache cache, Object key, Object value) {
        try {
            cache.put(key, value);
        }
        catch (RuntimeException ex) {
            this.getExceptionResolver().resolvePutException(ex, cache, key, ex);
        }
    }

    public void evict(Cache cache, Object key) {
        try {
            cache.evict(key);
        }
        catch (RuntimeException ex) {
            this.getExceptionResolver().resolveEvictException(ex, cache, key);
        }
    }

    public void clear(Cache cache) {
        try {
            cache.clear();
        }
        catch (RuntimeException ex) {
            this.getExceptionResolver().resolveClearException(ex, cache);
        }
    }

    public final CacheExceptionResolver getExceptionResolver() {
        return this.exceptionResolver;
    }

    public void setExceptionResolver(CacheExceptionResolver exceptionResolver) {
        this.exceptionResolver = exceptionResolver;
    }
}

