/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache;

import cn.taketoday.cache.AbstractMappingFunctionCache;
import cn.taketoday.context.utils.ConcurrentCache;
import java.util.function.UnaryOperator;

public class ConcurrentMapCache
extends AbstractMappingFunctionCache {
    private final ConcurrentCache<Object, Object> store;

    public ConcurrentMapCache() {
        this("default");
    }

    public ConcurrentMapCache(String name) {
        this(name, 256);
    }

    public ConcurrentMapCache(String name, int size) {
        this(name, new ConcurrentCache<Object, Object>(size));
    }

    protected ConcurrentMapCache(String name, ConcurrentCache<Object, Object> store) {
        this.setName(name);
        this.store = store;
    }

    @Override
    protected Object getInternal(Object key, UnaryOperator<Object> mappingFunction) {
        return this.store.get(key, mappingFunction);
    }

    @Override
    public void evict(Object key) {
        this.store.remove(key);
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    protected Object lookupValue(Object key) {
        return this.store.get(key);
    }

    @Override
    protected void putInternal(Object key, Object value) {
        this.store.put(key, value);
    }
}

