/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache;

import cn.taketoday.cache.AbstractCacheManager;
import cn.taketoday.cache.Cache;
import cn.taketoday.cache.CaffeineCache;
import cn.taketoday.cache.annotation.CacheConfig;
import cn.taketoday.context.utils.Assert;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;

public class CaffeineCacheManager
extends AbstractCacheManager {
    private CacheLoader<Object, Object> cacheLoader;
    private Caffeine<Object, Object> caffeine = Caffeine.newBuilder();

    @Override
    protected Cache doCreate(String name, CacheConfig cacheConfig) {
        if (CaffeineCacheManager.isDefaultConfig(cacheConfig)) {
            return this.adaptCaffeineCache(name, this.createNativeCaffeineCache());
        }
        Caffeine caffeine = Caffeine.newBuilder().expireAfterWrite(cacheConfig.expire(), cacheConfig.timeUnit());
        int maxSize = cacheConfig.maxSize();
        if (maxSize != 0) {
            caffeine.maximumSize((long)maxSize);
        }
        return this.adaptCaffeineCache(name, this.createNativeCaffeineCache((Caffeine<Object, Object>)caffeine));
    }

    public void registerCustomCache(String name, com.github.benmanes.caffeine.cache.Cache<Object, Object> cache) {
        this.registerCustomCache(name, this.adaptCaffeineCache(name, cache));
    }

    public void setCaffeine(Caffeine<Object, Object> caffeine) {
        Assert.notNull(caffeine, "Caffeine must not be null");
        this.caffeine = caffeine;
    }

    public void setCaffeineSpec(CaffeineSpec caffeineSpec) {
        this.setCaffeine((Caffeine<Object, Object>)Caffeine.from((CaffeineSpec)caffeineSpec));
    }

    public void setCacheSpecification(String cacheSpecification) {
        this.setCaffeine((Caffeine<Object, Object>)Caffeine.from((String)cacheSpecification));
    }

    public void setCacheLoader(CacheLoader<Object, Object> cacheLoader) {
        this.cacheLoader = cacheLoader;
        this.refreshCaches();
    }

    protected Cache adaptCaffeineCache(String name, com.github.benmanes.caffeine.cache.Cache<Object, Object> cache) {
        return new CaffeineCache(name, cache);
    }

    protected com.github.benmanes.caffeine.cache.Cache<Object, Object> createNativeCaffeineCache() {
        return this.createNativeCaffeineCache(this.caffeine);
    }

    protected com.github.benmanes.caffeine.cache.Cache<Object, Object> createNativeCaffeineCache(Caffeine<Object, Object> caffeine) {
        return this.cacheLoader != null ? caffeine.build(this.cacheLoader) : caffeine.build();
    }
}

