/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.cache;

import cn.taketoday.expression.BeanNameExpressionResolver;
import cn.taketoday.expression.CompositeExpressionResolver;
import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.ExpressionResolver;
import cn.taketoday.expression.FunctionMapper;
import cn.taketoday.expression.StandardExpressionContext;
import cn.taketoday.expression.VariableMapper;
import cn.taketoday.expression.lang.LocalBeanNameResolver;
import java.util.HashMap;
import java.util.Map;

public class CacheExpressionContext
extends ExpressionContext {
    private ExpressionResolver elResolver;
    private final Map<String, Object> beans;
    private final StandardExpressionContext parent;

    public CacheExpressionContext(StandardExpressionContext parent) {
        this(parent, new HashMap<String, Object>(4));
    }

    public CacheExpressionContext(StandardExpressionContext parent, Map<String, Object> beans) {
        this.beans = beans;
        this.parent = parent;
    }

    @Override
    public ExpressionResolver getResolver() {
        ExpressionResolver ret = this.elResolver;
        if (ret == null) {
            this.elResolver = new CompositeExpressionResolver(new BeanNameExpressionResolver(new LocalBeanNameResolver(this.beans)), this.parent.getResolver());
            return this.elResolver;
        }
        return ret;
    }

    public void putBean(String name, Object bean) {
        this.beans.put(name, bean);
    }

    @Override
    public FunctionMapper getFunctionMapper() {
        return this.parent.getFunctionMapper();
    }

    @Override
    public VariableMapper getVariableMapper() {
        return this.parent.getVariableMapper();
    }

    @Override
    public void setPropertyResolved(Object base, Object property) {
        this.setPropertyResolved(true);
    }
}

