/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.support.interceptor;

import cn.taketoday.aop.support.interceptor.AbstractTraceInterceptor;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.utils.Assert;
import org.aopalliance.intercept.MethodInvocation;

public class SimpleTraceInterceptor
extends AbstractTraceInterceptor {
    public SimpleTraceInterceptor() {
    }

    public SimpleTraceInterceptor(boolean useDynamicLogger) {
        this.setUseDynamicLogger(useDynamicLogger);
    }

    @Override
    protected Object invokeUnderTrace(MethodInvocation invocation, Logger logger) throws Throwable {
        String invocationDescription = this.getInvocationDescription(invocation);
        this.writeToLog(logger, "Entering " + invocationDescription);
        try {
            Object rval = invocation.proceed();
            this.writeToLog(logger, "Exiting " + invocationDescription);
            return rval;
        }
        catch (Throwable ex) {
            this.writeToLog(logger, "Exception thrown in " + invocationDescription, ex);
            throw ex;
        }
    }

    protected String getInvocationDescription(MethodInvocation invocation) {
        Object target = invocation.getThis();
        Assert.state(target != null, "Target must not be null");
        String className = target.getClass().getName();
        return "method '" + invocation.getMethod().getName() + "' of class [" + className + "]";
    }
}

