/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.support.interceptor;

import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.utils.Assert;
import java.io.Serializable;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public abstract class AbstractTraceInterceptor
implements MethodInterceptor,
Serializable {
    protected transient Logger defaultLogger = LoggerFactory.getLogger(this.getClass());
    private boolean hideProxyClassNames = false;
    private boolean logExceptionStackTrace = true;

    public void setUseDynamicLogger(boolean useDynamicLogger) {
        this.defaultLogger = useDynamicLogger ? null : LoggerFactory.getLogger(this.getClass());
    }

    public void setLoggerName(String loggerName) {
        this.defaultLogger = LoggerFactory.getLogger(loggerName);
    }

    public void setHideProxyClassNames(boolean hideProxyClassNames) {
        this.hideProxyClassNames = hideProxyClassNames;
    }

    public void setLogExceptionStackTrace(boolean logExceptionStackTrace) {
        this.logExceptionStackTrace = logExceptionStackTrace;
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Logger logger = this.getLoggerForInvocation(invocation);
        if (this.isInterceptorEnabled(invocation, logger)) {
            return this.invokeUnderTrace(invocation, logger);
        }
        return invocation.proceed();
    }

    protected Logger getLoggerForInvocation(MethodInvocation invocation) {
        if (this.defaultLogger != null) {
            return this.defaultLogger;
        }
        Object target = invocation.getThis();
        Assert.state(target != null, "Target must not be null");
        return LoggerFactory.getLogger(this.getClassForLogging(target));
    }

    protected Class<?> getClassForLogging(Object target) {
        return this.hideProxyClassNames ? AopUtils.getTargetClass(target) : target.getClass();
    }

    protected boolean isInterceptorEnabled(MethodInvocation invocation, Logger logger) {
        return this.isLogEnabled(logger);
    }

    protected boolean isLogEnabled(Logger logger) {
        return logger.isTraceEnabled();
    }

    protected void writeToLog(Logger logger, String message) {
        this.writeToLog(logger, message, null);
    }

    protected void writeToLog(Logger logger, String message, Throwable ex) {
        if (ex != null && this.logExceptionStackTrace) {
            logger.trace(message, ex);
        } else {
            logger.trace(message);
        }
    }

    protected abstract Object invokeUnderTrace(MethodInvocation var1, Logger var2) throws Throwable;
}

