/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.support.interceptor;

import cn.taketoday.aop.support.interceptor.AbstractTraceInterceptor;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;

public abstract class AbstractMonitoringInterceptor
extends AbstractTraceInterceptor {
    private String prefix = "";
    private String suffix = "";
    private boolean logTargetClassInvocation = false;

    public void setPrefix(String prefix) {
        this.prefix = prefix != null ? prefix : "";
    }

    protected String getPrefix() {
        return this.prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix != null ? suffix : "";
    }

    protected String getSuffix() {
        return this.suffix;
    }

    public void setLogTargetClassInvocation(boolean logTargetClassInvocation) {
        this.logTargetClassInvocation = logTargetClassInvocation;
    }

    protected String createInvocationTraceName(MethodInvocation invocation) {
        Method method = invocation.getMethod();
        Class<?> clazz = method.getDeclaringClass();
        if (this.logTargetClassInvocation && clazz.isInstance(invocation.getThis())) {
            clazz = invocation.getThis().getClass();
        }
        String className = clazz.getName();
        return this.getPrefix() + className + '.' + method.getName() + this.getSuffix();
    }
}

