/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.support;

import cn.taketoday.aop.MethodMatcher;
import cn.taketoday.context.utils.Assert;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public final class RuntimeMethodInterceptor
implements MethodInterceptor {
    private final MethodMatcher methodMatcher;
    private final MethodInterceptor interceptor;

    public RuntimeMethodInterceptor(MethodInterceptor interceptor, MethodMatcher methodMatcher) {
        Assert.notNull((Object)interceptor, "interceptor must not be null");
        Assert.notNull((Object)methodMatcher, "methodMatcher must not be null");
        Assert.state(methodMatcher.isRuntime(), "methodMatcher must be a runtime Matcher");
        this.interceptor = interceptor;
        this.methodMatcher = methodMatcher;
    }

    @Override
    public final Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.methodMatcher.matches(invocation)) {
            return this.interceptor.invoke(invocation);
        }
        return invocation.proceed();
    }
}

