/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.proxy.std;

import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.proxy.AdvisedSupport;
import cn.taketoday.aop.proxy.std.DefaultProxyMethodGenerator;
import cn.taketoday.aop.proxy.std.GeneratorContext;
import cn.taketoday.aop.proxy.std.ProxyMethodGenerator;
import cn.taketoday.context.asm.Type;
import cn.taketoday.context.cglib.core.CglibReflectUtils;
import cn.taketoday.context.cglib.core.ClassEmitter;
import cn.taketoday.context.cglib.core.CodeEmitter;
import cn.taketoday.context.cglib.core.CodeGenerationException;
import cn.taketoday.context.cglib.core.EmitUtils;
import cn.taketoday.context.cglib.core.MethodInfo;
import cn.taketoday.context.cglib.core.Signature;
import cn.taketoday.context.utils.ObjectUtils;
import java.lang.reflect.Method;

public class NoneProxyMethodGenerator
implements ProxyMethodGenerator {
    static final Signature targetSourceGetTarget;
    static final Type targetSourceType;

    @Override
    public boolean generate(Method method, GeneratorContext context) {
        AdvisedSupport config = context.getConfig();
        Object[] interceptors = context.getConfig().getInterceptors(method, context.getTargetClass());
        if (ObjectUtils.isEmpty(interceptors)) {
            TargetSource targetSource = config.getTargetSource();
            if (targetSource.isStatic()) {
                this.invokeStaticTarget(method, context);
            } else {
                this.invokeTargetFromTargetSource(method, context);
            }
            return true;
        }
        return false;
    }

    protected void invokeStaticTarget(Method method, GeneratorContext context) {
        ClassEmitter emitter = context.getClassEmitter();
        int modifiers = DefaultProxyMethodGenerator.excludeAbstractModifiers(method);
        MethodInfo methodInfo = CglibReflectUtils.getMethodInfo(method, modifiers);
        CodeEmitter codeEmitter = EmitUtils.beginMethod(emitter, methodInfo, modifiers);
        codeEmitter.load_this();
        codeEmitter.getfield("target");
        codeEmitter.load_args();
        codeEmitter.invoke(methodInfo);
        codeEmitter.return_value();
        codeEmitter.unbox_or_zero(Type.getType(method.getReturnType()));
        codeEmitter.end_method();
    }

    protected void invokeTargetFromTargetSource(Method method, GeneratorContext context) {
        ClassEmitter emitter = context.getClassEmitter();
        int modifiers = DefaultProxyMethodGenerator.excludeAbstractModifiers(method);
        MethodInfo methodInfo = CglibReflectUtils.getMethodInfo(method, modifiers);
        CodeEmitter codeEmitter = EmitUtils.beginMethod(emitter, methodInfo, modifiers);
        codeEmitter.load_this();
        codeEmitter.getfield("targetSource");
        codeEmitter.invoke_interface(targetSourceType, targetSourceGetTarget);
        codeEmitter.checkcast(context.getTargetType());
        codeEmitter.load_args();
        codeEmitter.invoke(methodInfo);
        codeEmitter.return_value();
        codeEmitter.unbox_or_zero(Type.getType(method.getReturnType()));
        codeEmitter.end_method();
    }

    static {
        targetSourceType = Type.getType(TargetSource.class);
        try {
            targetSourceGetTarget = new Signature(TargetSource.class.getDeclaredMethod("getTarget", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new CodeGenerationException(e);
        }
    }
}

