/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.proxy;

import cn.taketoday.aop.Advisor;
import cn.taketoday.aop.DynamicIntroductionAdvice;
import cn.taketoday.aop.IntroductionAdvisor;
import cn.taketoday.aop.IntroductionInfo;
import cn.taketoday.aop.TargetSource;
import cn.taketoday.aop.proxy.Advised;
import cn.taketoday.aop.proxy.AopConfigException;
import cn.taketoday.aop.proxy.ProxyConfig;
import cn.taketoday.aop.support.AopUtils;
import cn.taketoday.aop.support.DefaultIntroductionAdvisor;
import cn.taketoday.aop.support.DefaultPointcutAdvisor;
import cn.taketoday.aop.target.EmptyTargetSource;
import cn.taketoday.aop.target.SingletonTargetSource;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import cn.taketoday.context.utils.CollectionUtils;
import cn.taketoday.context.utils.OrderUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;

public class AdvisedSupport
extends ProxyConfig
implements Advised {
    private static final long serialVersionUID = 1L;
    public static final TargetSource EMPTY_TARGET_SOURCE = EmptyTargetSource.INSTANCE;
    TargetSource targetSource = EMPTY_TARGET_SOURCE;
    private boolean preFiltered = false;
    private transient ConcurrentHashMap<MethodCacheKey, MethodInterceptor[]> methodCache;
    private ArrayList<Class<?>> interfaces = new ArrayList();
    private ArrayList<Advisor> advisors = new ArrayList();

    public AdvisedSupport() {
        this.methodCache = new ConcurrentHashMap(32);
    }

    public AdvisedSupport(Class<?> ... interfaces) {
        this();
        this.setInterfaces(interfaces);
    }

    public void setTarget(Object target) {
        this.setTargetSource(new SingletonTargetSource(target));
    }

    @Override
    public void setTargetSource(TargetSource targetSource) {
        this.targetSource = targetSource != null ? targetSource : EMPTY_TARGET_SOURCE;
    }

    @Override
    public TargetSource getTargetSource() {
        return this.targetSource;
    }

    public void setTargetClass(Class<?> targetClass) {
        this.targetSource = EmptyTargetSource.forClass(targetClass);
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetSource.getTargetClass();
    }

    @Override
    public void setPreFiltered(boolean preFiltered) {
        this.preFiltered = preFiltered;
    }

    @Override
    public boolean isPreFiltered() {
        return this.preFiltered;
    }

    public void setInterfaces(Class<?> ... interfaces) {
        Assert.notNull(interfaces, "Interfaces must not be null");
        this.interfaces.clear();
        for (Class<?> ifc : interfaces) {
            this.addInterface(ifc);
        }
    }

    public void addInterface(Class<?> intf) {
        Assert.notNull(intf, "Interface must not be null");
        if (!intf.isInterface()) {
            throw new IllegalArgumentException("[" + intf.getName() + "] is not an interface");
        }
        if (!this.interfaces.contains(intf)) {
            this.interfaces.add(intf);
            this.adviceChanged();
        }
    }

    public boolean removeInterface(Class<?> intf) {
        return this.interfaces.remove(intf);
    }

    @Override
    public Class<?>[] getProxiedInterfaces() {
        return ClassUtils.toClassArray(this.interfaces);
    }

    @Override
    public boolean isInterfaceProxied(Class<?> intf) {
        for (Class<?> proxyIntf : this.interfaces) {
            if (!intf.isAssignableFrom(proxyIntf)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Advisor[] getAdvisors() {
        return this.advisors.toArray(new Advisor[0]);
    }

    @Override
    public int getAdvisorCount() {
        return this.advisors.size();
    }

    @Override
    public void addAdvisor(Advisor advisor) {
        int pos = this.advisors.size();
        this.addAdvisor(pos, advisor);
    }

    @Override
    public void addAdvisor(int pos, Advisor advisor) {
        if (advisor instanceof IntroductionAdvisor) {
            this.validateIntroductionAdvisor((IntroductionAdvisor)advisor);
        }
        this.addAdvisorInternal(pos, advisor);
    }

    @Override
    public boolean removeAdvisor(Advisor advisor) {
        int index = this.indexOf(advisor);
        if (index == -1) {
            return false;
        }
        this.removeAdvisor(index);
        return true;
    }

    @Override
    public void removeAdvisor(int index) {
        if (this.isFrozen()) {
            throw new AopConfigException("Cannot remove Advisor: Configuration is frozen.");
        }
        if (index < 0 || index > this.advisors.size() - 1) {
            throw new AopConfigException("Advisor index " + index + " is out of bounds: This configuration only has " + this.advisors.size() + " advisors.");
        }
        Advisor advisor = this.advisors.remove(index);
        if (advisor instanceof IntroductionAdvisor) {
            IntroductionAdvisor ia = (IntroductionAdvisor)advisor;
            for (Class<?> ifc : ia.getInterfaces()) {
                this.removeInterface(ifc);
            }
        }
        this.adviceChanged();
    }

    @Override
    public int indexOf(Advisor advisor) {
        Assert.notNull((Object)advisor, "Advisor must not be null");
        return this.advisors.indexOf(advisor);
    }

    @Override
    public boolean replaceAdvisor(Advisor a, Advisor b) throws AopConfigException {
        Assert.notNull((Object)a, "Advisor a must not be null");
        Assert.notNull((Object)b, "Advisor b must not be null");
        int index = this.indexOf(a);
        if (index == -1) {
            return false;
        }
        this.removeAdvisor(index);
        this.addAdvisor(index, b);
        return true;
    }

    public void addAdvisors(Advisor ... advisors) {
        this.addAdvisors(Arrays.asList(advisors));
    }

    public void addAdvisors(Collection<Advisor> advisors) {
        if (this.isFrozen()) {
            throw new AopConfigException("Cannot add advisor: Configuration is frozen.");
        }
        if (!CollectionUtils.isEmpty(advisors)) {
            for (Advisor advisor : advisors) {
                Assert.notNull((Object)advisor, "Advisor must not be null");
                if (advisor instanceof IntroductionAdvisor) {
                    this.validateIntroductionAdvisor((IntroductionAdvisor)advisor);
                }
                this.advisors.add(advisor);
            }
            this.adviceChanged();
        }
    }

    private void validateIntroductionAdvisor(IntroductionAdvisor advisor) {
        Class<?>[] ifcs;
        advisor.validateInterfaces();
        for (Class<?> ifc : ifcs = advisor.getInterfaces()) {
            this.addInterface(ifc);
        }
    }

    void addAdvisorInternal(int pos, Advisor advisor) throws AopConfigException {
        Assert.notNull((Object)advisor, "Advisor must not be null");
        if (this.isFrozen()) {
            throw new AopConfigException("Cannot add advisor: Configuration is frozen.");
        }
        if (pos > this.advisors.size()) {
            throw new IllegalArgumentException("Illegal position " + pos + " in advisor list with size " + this.advisors.size());
        }
        this.advisors.add(pos, advisor);
        this.adviceChanged();
    }

    protected final List<Advisor> getAdvisorsInternal() {
        return this.advisors;
    }

    @Override
    public void addAdvice(Advice advice) throws AopConfigException {
        int pos = this.advisors.size();
        this.addAdvice(pos, advice);
    }

    @Override
    public void addAdvice(int pos, Advice advice) throws AopConfigException {
        Assert.notNull((Object)advice, "Advice must not be null");
        if (advice instanceof IntroductionInfo) {
            this.addAdvisor(pos, new DefaultIntroductionAdvisor(advice, (IntroductionInfo)((Object)advice)));
        } else {
            if (advice instanceof DynamicIntroductionAdvice) {
                throw new AopConfigException("DynamicIntroductionAdvice may only be added as part of IntroductionAdvisor");
            }
            this.addAdvisor(pos, new DefaultPointcutAdvisor(advice));
        }
    }

    @Override
    public boolean removeAdvice(Advice advice) throws AopConfigException {
        int index = this.indexOf(advice);
        if (index == -1) {
            return false;
        }
        this.removeAdvisor(index);
        return true;
    }

    @Override
    public int indexOf(Advice advice) {
        Assert.notNull((Object)advice, "Advice must not be null");
        ArrayList<Advisor> advisors = this.advisors;
        for (int i = 0; i < advisors.size(); ++i) {
            Advisor advisor = advisors.get(i);
            if (advisor.getAdvice() != advice) continue;
            return i;
        }
        return -1;
    }

    public boolean adviceIncluded(Advice advice) {
        if (advice != null) {
            for (Advisor advisor : this.advisors) {
                if (advisor.getAdvice() != advice) continue;
                return true;
            }
        }
        return false;
    }

    public int countAdvicesOfType(Class<?> adviceClass) {
        int count = 0;
        if (adviceClass != null) {
            for (Advisor advisor : this.advisors) {
                if (!adviceClass.isInstance(advisor.getAdvice())) continue;
                ++count;
            }
        }
        return count;
    }

    public MethodInterceptor[] getInterceptors(Method method, Class<?> targetClass) {
        MethodCacheKey cacheKey = new MethodCacheKey(method);
        MethodInterceptor[] cached = this.methodCache.get(cacheKey);
        if (cached == null) {
            cached = AopUtils.getInterceptorsArray(this, method, targetClass);
            OrderUtils.reversedSort(cached);
            this.methodCache.put(cacheKey, cached);
        }
        return cached;
    }

    protected void adviceChanged() {
        this.methodCache.clear();
    }

    protected void copyConfigurationFrom(AdvisedSupport other) {
        this.copyConfigurationFrom(other, other.targetSource, new ArrayList<Advisor>(other.advisors));
    }

    protected void copyConfigurationFrom(AdvisedSupport other, TargetSource targetSource, List<Advisor> advisors) {
        this.copyFrom(other);
        this.targetSource = targetSource;
        this.interfaces = new ArrayList(other.interfaces);
        for (Advisor advisor : advisors) {
            Assert.notNull((Object)advisor, "Advisor must not be null");
            if (advisor instanceof IntroductionAdvisor) {
                this.validateIntroductionAdvisor((IntroductionAdvisor)advisor);
            }
            this.advisors.add(advisor);
        }
        this.adviceChanged();
    }

    AdvisedSupport getConfigurationOnlyCopy() {
        AdvisedSupport copy = new AdvisedSupport();
        copy.copyFrom(this);
        copy.targetSource = EmptyTargetSource.forClass(this.getTargetClass(), this.getTargetSource().isStatic());
        copy.interfaces = this.interfaces;
        copy.advisors = this.advisors;
        return copy;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.methodCache = new ConcurrentHashMap(32);
    }

    @Override
    public String toProxyConfigString() {
        return this.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append(": ").append(this.interfaces.size()).append(" interfaces ");
        sb.append(ClassUtils.classNamesToString(this.interfaces)).append("; ");
        sb.append(this.advisors.size()).append(" advisors ");
        sb.append(this.advisors).append("; ");
        sb.append("targetSource [").append(this.targetSource).append("]; ");
        sb.append(super.toString());
        return sb.toString();
    }

    static final class MethodCacheKey
    implements Comparable<MethodCacheKey> {
        private final int hashCode;
        private final Method method;

        public MethodCacheKey(Method method) {
            this.method = method;
            this.hashCode = method.hashCode();
        }

        public boolean equals(Object other) {
            return this == other || other instanceof MethodCacheKey && this.method == ((MethodCacheKey)other).method;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.method.toString();
        }

        @Override
        public int compareTo(MethodCacheKey other) {
            int result = this.method.getName().compareTo(other.method.getName());
            if (result == 0) {
                result = this.method.toString().compareTo(other.method.toString());
            }
            return result;
        }
    }
}

