/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.aop.proxy;

import cn.taketoday.aop.proxy.AdvisedSupport;
import cn.taketoday.aop.proxy.AopConfigException;
import cn.taketoday.aop.proxy.AopProxy;
import cn.taketoday.context.cglib.core.CodeGenerationException;
import cn.taketoday.context.logger.Logger;
import cn.taketoday.context.logger.LoggerFactory;
import cn.taketoday.context.utils.Assert;
import cn.taketoday.context.utils.ClassUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;

public abstract class AbstractSubclassesAopProxy
implements AopProxy {
    private static final Logger log = LoggerFactory.getLogger(AbstractSubclassesAopProxy.class);
    private static final Map<Class<?>, Boolean> validatedClasses = new WeakHashMap();
    static final Function<Constructor<?>, Object[]> defaultArgsFunction = constructor -> null;
    final AdvisedSupport config;
    protected Object[] constructorArgs;
    protected Class<?>[] constructorArgTypes;

    public AbstractSubclassesAopProxy(AdvisedSupport config) {
        Assert.notNull((Object)config, "AdvisedSupport must not be null");
        if (config.getAdvisors().length == 0 && config.getTargetSource() == AdvisedSupport.EMPTY_TARGET_SOURCE) {
            throw new AopConfigException("No advisors and no TargetSource specified");
        }
        this.config = config;
    }

    public void setConstructorArguments(Object[] constructorArgs, Class<?>[] constructorArgTypes) {
        if (constructorArgs == null || constructorArgTypes == null) {
            throw new IllegalArgumentException("Both 'constructorArgs' and 'constructorArgTypes' need to be specified");
        }
        if (constructorArgs.length != constructorArgTypes.length) {
            throw new IllegalArgumentException("Number of 'constructorArgs' (" + constructorArgs.length + ") must match number of 'constructorArgTypes' (" + constructorArgTypes.length + ")");
        }
        this.constructorArgs = constructorArgs;
        this.constructorArgTypes = constructorArgTypes;
    }

    @Override
    public Object getProxy(ClassLoader classLoader) {
        return this.getProxy(classLoader, defaultArgsFunction);
    }

    @Override
    public Object getProxy(ClassLoader classLoader, Function<Constructor<?>, Object[]> argsFunction) {
        try {
            Class<?> rootClass = this.config.getTargetClass();
            Assert.state(rootClass != null, "Target class must be available for creating a CGLIB proxy");
            Class<?> proxySuperClass = this.getProxySuperClass(rootClass);
            this.validateClassIfNecessary(proxySuperClass, classLoader);
            return this.getProxyInternal(proxySuperClass, classLoader, argsFunction);
        }
        catch (CodeGenerationException | IllegalArgumentException ex) {
            throw new AopConfigException("Could not generate subclass of " + this.config.getTargetClass() + ": Common causes of this problem include using a final class or a non-visible class", ex);
        }
        catch (Throwable ex) {
            throw new AopConfigException("Unexpected AOP exception", ex);
        }
    }

    protected Class<?> getProxySuperClass(Class<?> rootClass) {
        Class<?> proxySuperClass = rootClass;
        if (rootClass.getName().contains("$$")) {
            Class<?>[] additionalInterfaces;
            proxySuperClass = rootClass.getSuperclass();
            for (Class<?> additionalInterface : additionalInterfaces = rootClass.getInterfaces()) {
                this.config.addInterface(additionalInterface);
            }
        }
        return proxySuperClass;
    }

    abstract Object getProxyInternal(Class<?> var1, ClassLoader var2, Function<Constructor<?>, Object[]> var3) throws Exception;

    protected void computeConstructorArguments(Function<Constructor<?>, Object[]> argsFunction, Class<?> proxySuperClass) {
        if (argsFunction != null && argsFunction != defaultArgsFunction) {
            Constructor<?> superConstructor = ClassUtils.obtainConstructor(proxySuperClass);
            Object[] args = argsFunction.apply(superConstructor);
            this.setConstructorArguments(args, superConstructor.getParameterTypes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateClassIfNecessary(Class<?> proxySuperClass, ClassLoader proxyClassLoader) {
        if (log.isWarnEnabled()) {
            Map<Class<?>, Boolean> map = validatedClasses;
            synchronized (map) {
                if (!validatedClasses.containsKey(proxySuperClass)) {
                    this.doValidateClass(proxySuperClass, proxyClassLoader, ClassUtils.getAllInterfacesForClassAsSet(proxySuperClass));
                    validatedClasses.put(proxySuperClass, Boolean.TRUE);
                }
            }
        }
    }

    void doValidateClass(Class<?> proxySuperClass, ClassLoader proxyClassLoader, Set<Class<?>> ifcs) {
        if (proxySuperClass != Object.class) {
            Method[] methods;
            for (Method method : methods = proxySuperClass.getDeclaredMethods()) {
                int mod = method.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isPrivate(mod)) continue;
                if (Modifier.isFinal(mod)) {
                    if (log.isInfoEnabled() && AbstractSubclassesAopProxy.implementsInterface(method, ifcs)) {
                        log.info("Unable to proxy interface-implementing method [{}] because it is marked as final: Consider using interface-based JDK proxies instead!", (Object)method);
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Final method [{}] cannot get proxied via CGLIB: Calls to this method will NOT be routed to the target instance and might lead to NPEs against uninitialized fields in the proxy instance.", (Object)method);
                    continue;
                }
                if (!log.isDebugEnabled() || Modifier.isPublic(mod) || Modifier.isProtected(mod) || proxyClassLoader == null || proxySuperClass.getClassLoader() == proxyClassLoader) continue;
                log.debug("Method [{}] is package-visible across different ClassLoaders and cannot get proxied via CGLIB: Declare this method as public or protected if you need to support invocations through the proxy.", (Object)method);
            }
            this.doValidateClass(proxySuperClass.getSuperclass(), proxyClassLoader, ifcs);
        }
    }

    static boolean implementsInterface(Method method, Set<Class<?>> ifcs) {
        for (Class<?> ifc : ifcs) {
            if (!ClassUtils.hasMethod(ifc, method)) continue;
            return true;
        }
        return false;
    }
}

