/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression.stream;

import cn.taketoday.context.utils.ObjectUtils;
import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.ExpressionResolver;
import cn.taketoday.expression.stream.Stream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

public class StreamExpressionResolver
extends ExpressionResolver {
    private static final StreamExpressionResolver INSTANCE = new StreamExpressionResolver();

    public static final StreamExpressionResolver getInstance() {
        return INSTANCE;
    }

    @Override
    public Object invoke(ExpressionContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        if ("stream".equals(method) && ObjectUtils.isEmpty(params)) {
            Objects.requireNonNull(context).setPropertyResolved(true);
            if (base.getClass().isArray()) {
                return new Stream(StreamExpressionResolver.arrayIterator(base));
            }
            if (base instanceof Collection) {
                return new Stream(((Collection)base).iterator());
            }
        }
        return null;
    }

    private static Iterator<Object> arrayIterator(final Object base) {
        final int size = Array.getLength(base);
        return new Iterator<Object>(){
            private int index = 0;
            private boolean yielded;
            private Object current;

            @Override
            public boolean hasNext() {
                if (!this.yielded && this.index < size) {
                    this.current = Array.get(base, this.index++);
                    this.yielded = true;
                }
                return this.yielded;
            }

            @Override
            public Object next() {
                this.yielded = false;
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Object getValue(ExpressionContext context, Object base, Object property) {
        return null;
    }

    @Override
    public Class<?> getType(ExpressionContext context, Object base, Object property) {
        return null;
    }

    @Override
    public void setValue(ExpressionContext context, Object base, Object property, Object value) {
    }

    @Override
    public boolean isReadOnly(ExpressionContext context, Object base, Object property) {
        return false;
    }
}

