/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression.parser;

import cn.taketoday.context.utils.ObjectUtils;
import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.MethodInfo;
import cn.taketoday.expression.PropertyNotWritableException;
import cn.taketoday.expression.ValueReference;
import cn.taketoday.expression.lang.EvaluationContext;
import cn.taketoday.expression.parser.ELParserTreeConstants;
import cn.taketoday.expression.parser.Node;
import cn.taketoday.expression.parser.NodeVisitor;
import java.util.Objects;

public abstract class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected final int id;
    protected String image;

    public SimpleNode(int i) {
        this.id = i;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return this.image != null ? ELParserTreeConstants.NODE_NAME[this.id] + "[" + this.image + "]" : ELParserTreeConstants.NODE_NAME[this.id];
    }

    public String toString(String prefix) {
        return Objects.requireNonNull(prefix).concat(this.toString());
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (Node child : this.children) {
                SimpleNode n = (SimpleNode)child;
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    @Override
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @Override
    public Class<?> getType(EvaluationContext ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getValue(EvaluationContext ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueReference getValueReference(EvaluationContext ctx) {
        return null;
    }

    @Override
    public boolean isReadOnly(EvaluationContext ctx) {
        return true;
    }

    @Override
    public void setValue(EvaluationContext ctx, Object value) {
        throw new PropertyNotWritableException("Illegal Syntax for Set Operation");
    }

    @Override
    public void accept(NodeVisitor visitor, ExpressionContext context) {
        visitor.visit(this, context);
        Object[] children = this.children;
        if (ObjectUtils.isNotEmpty(children)) {
            for (Object node : children) {
                node.accept(visitor, context);
            }
        }
    }

    @Override
    public Object invoke(EvaluationContext ctx, Class<?>[] paramTypes, Object[] paramValues) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MethodInfo getMethodInfo(EvaluationContext ctx, Class<?>[] paramTypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object node) {
        if (!(node instanceof SimpleNode)) {
            return false;
        }
        SimpleNode n = (SimpleNode)node;
        if (this.id != n.id) {
            return false;
        }
        Node[] children = this.children;
        if (children == null && n.children == null) {
            if (this.image == null) {
                return n.image == null;
            }
            return this.image.equals(n.image);
        }
        if (children == null || n.children == null) {
            return false;
        }
        if (children.length != n.children.length) {
            return false;
        }
        if (children.length == 0) {
            if (this.image == null) {
                return n.image == null;
            }
            return this.image.equals(n.image);
        }
        for (int i = 0; i < children.length; ++i) {
            if (children[i].equals(n.children[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isParametersProvided() {
        return false;
    }

    @Override
    public int hashCode() {
        Node[] children = this.children;
        if (children == null || children.length == 0) {
            if (this.image != null) {
                return this.image.hashCode();
            }
            return this.id;
        }
        int h = 0;
        for (int i = children.length - 1; i >= 0; --i) {
            h = h + h + h + children[i].hashCode();
        }
        h = h + h + h + this.id;
        return h;
    }
}

