/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression;

import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.ExpressionException;
import cn.taketoday.expression.ExpressionFactory;
import cn.taketoday.expression.ValueExpression;
import cn.taketoday.expression.ValueReference;
import cn.taketoday.expression.lang.EvaluationContext;
import cn.taketoday.expression.parser.AstLiteralExpression;
import cn.taketoday.expression.parser.Node;

public final class ValueExpressionImpl
extends ValueExpression {
    private static final long serialVersionUID = 1L;
    private final String expr;
    private transient Node node;
    private final Class<?> expectedType;

    public ValueExpressionImpl(String expr, Node node, Class<?> expectedType) {
        this.expr = expr;
        this.node = node;
        this.expectedType = expectedType;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ValueExpressionImpl) {
            return this.getNode().equals(((ValueExpressionImpl)obj).getNode());
        }
        return false;
    }

    @Override
    public Class<?> getExpectedType() {
        return this.expectedType;
    }

    @Override
    public String getExpressionString() {
        return this.expr;
    }

    private Node getNode() throws ExpressionException {
        if (this.node == null) {
            this.node = ExpressionFactory.createNode(this.expr);
        }
        return this.node;
    }

    @Override
    public Class<?> getType(ExpressionContext context) throws ExpressionException {
        return this.getNode().getType(new EvaluationContext(context));
    }

    @Override
    public ValueReference getValueReference(ExpressionContext context) throws ExpressionException {
        return this.getNode().getValueReference(new EvaluationContext(context));
    }

    @Override
    public Object getValue(ExpressionContext context) throws ExpressionException {
        Object value = this.getNode().getValue(new EvaluationContext(context));
        if (value != null && this.expectedType != null) {
            try {
                if (!this.expectedType.isInstance(value)) {
                    value = context.convertToType(value, this.expectedType);
                }
            }
            catch (IllegalArgumentException ex) {
                throw new ExpressionException(ex);
            }
        }
        return value;
    }

    @Override
    public int hashCode() {
        return this.getNode().hashCode();
    }

    @Override
    public boolean isLiteralText() {
        try {
            return this.getNode() instanceof AstLiteralExpression;
        }
        catch (ExpressionException ele) {
            return false;
        }
    }

    @Override
    public boolean isReadOnly(ExpressionContext context) throws ExpressionException {
        return this.getNode().isReadOnly(new EvaluationContext(context));
    }

    @Override
    public void setValue(ExpressionContext context, Object value) throws ExpressionException {
        this.getNode().setValue(new EvaluationContext(context), value);
    }

    public String toString() {
        return "ValueExpression[" + this.expr + "]";
    }
}

