/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression;

import cn.taketoday.context.utils.ReflectionUtils;
import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.ExpressionResolver;
import cn.taketoday.expression.PropertyNotFoundException;
import cn.taketoday.expression.PropertyNotWritableException;
import cn.taketoday.expression.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;

public class StaticFieldExpressionResolver
extends ExpressionResolver {
    @Override
    public Object getValue(ExpressionContext context, Object base, Object property) {
        if (base instanceof Class && property instanceof String) {
            Objects.requireNonNull(context).setPropertyResolved(base, property);
            Field field = ReflectionUtils.findField((Class)base, (String)property);
            if (field == null) {
                throw new PropertyNotFoundException(((Class)base).getName() + " there is not a property: '" + property + '\'');
            }
            try {
                int mod = field.getModifiers();
                if (Modifier.isPublic(mod) && Modifier.isStatic(mod)) {
                    return field.get(null);
                }
            }
            catch (IllegalAccessException ex) {
                throw new PropertyNotFoundException("Either '" + ((Class)base).getName() + "' is not a public static field of the class '" + property + "' or field is inaccessible");
            }
        }
        return null;
    }

    @Override
    public void setValue(ExpressionContext context, Object base, Object property, Object value) {
        if (base instanceof Class && property instanceof String) {
            Class klass = (Class)base;
            String fieldName = (String)property;
            throw new PropertyNotWritableException("Cannot write to the field '" + klass.getName() + "' of the class '" + fieldName + "'");
        }
    }

    @Override
    public Object invoke(ExpressionContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        Object ret;
        if (!(base instanceof Class) || !(method instanceof String)) {
            return null;
        }
        Objects.requireNonNull(context);
        Class klass = (Class)base;
        String name = (String)method;
        if ("<init>".equals(name)) {
            Constructor<?> constructor = ReflectionUtil.findConstructor(klass, paramTypes, params);
            ret = ReflectionUtil.invokeConstructor(context, constructor, params);
        } else {
            Method meth = ReflectionUtil.findMethod(klass, name, paramTypes, params, true);
            ret = ReflectionUtil.invokeMethod(context, meth, null, params);
        }
        context.setPropertyResolved(base, method);
        return ret;
    }

    @Override
    public Class<?> getType(ExpressionContext context, Object base, Object property) {
        if (base instanceof Class && property instanceof String) {
            try {
                Objects.requireNonNull(context).setPropertyResolved(true);
                Field field = ((Class)base).getField((String)property);
                return field.getType();
            }
            catch (NoSuchFieldException ex) {
                throw new PropertyNotFoundException("Either '" + ((Class)base).getName() + "' is not a public static field of the class '" + property + "' or field is inaccessible");
            }
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ExpressionContext context, Object base, Object property) {
        if (base instanceof Class && property instanceof String) {
            Objects.requireNonNull(context).setPropertyResolved(true);
        }
        return true;
    }
}

