/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression;

import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.ExpressionResolver;
import cn.taketoday.expression.PropertyNotWritableException;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;

public class ResourceBundleExpressionResolver
extends ExpressionResolver {
    @Override
    public Object getValue(ExpressionContext context, Object base, Object property) {
        if (base instanceof ResourceBundle) {
            Objects.requireNonNull(context).setPropertyResolved(true);
            if (property != null) {
                try {
                    return ((ResourceBundle)base).getObject(property.toString());
                }
                catch (MissingResourceException e) {
                    return "???" + property + "???";
                }
            }
        }
        return null;
    }

    @Override
    public Class<?> getType(ExpressionContext context, Object base, Object property) {
        if (base instanceof ResourceBundle) {
            Objects.requireNonNull(context).setPropertyResolved(true);
        }
        return null;
    }

    @Override
    public void setValue(ExpressionContext context, Object base, Object property, Object value) {
        if (base instanceof ResourceBundle) {
            Objects.requireNonNull(context).setPropertyResolved(true);
            throw new PropertyNotWritableException("ResourceBundles are immutable");
        }
    }

    @Override
    public boolean isReadOnly(ExpressionContext context, Object base, Object property) {
        if (base instanceof ResourceBundle) {
            Objects.requireNonNull(context).setPropertyResolved(true);
            return true;
        }
        return false;
    }
}

