/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression;

import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.ExpressionResolver;
import cn.taketoday.expression.PropertyNotFoundException;
import cn.taketoday.expression.PropertyNotWritableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ListExpressionResolver
extends ExpressionResolver {
    private static Class<?> theUnmodifiableListClass = Collections.unmodifiableList(new ArrayList()).getClass();
    private boolean isReadOnly;

    public ListExpressionResolver() {
        this.isReadOnly = false;
    }

    public ListExpressionResolver(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    public Class<?> getType(ExpressionContext context, Object base, Object property) {
        if (base instanceof List) {
            Objects.requireNonNull(context).setPropertyResolved(true);
            int index = this.toInteger(property);
            if (index < 0 || index >= ((List)base).size()) {
                throw new PropertyNotFoundException();
            }
            return Object.class;
        }
        return null;
    }

    @Override
    public Object getValue(ExpressionContext context, Object base, Object property) {
        if (base instanceof List) {
            Objects.requireNonNull(context).setPropertyResolved(base, property);
            int index = this.toInteger(property);
            List list = (List)base;
            if (index < 0 || index >= list.size()) {
                return null;
            }
            return list.get(index);
        }
        return null;
    }

    @Override
    public void setValue(ExpressionContext context, Object base, Object property, Object val) {
        if (base instanceof List) {
            Objects.requireNonNull(context).setPropertyResolved(base, property);
            int index = this.toInteger(property);
            if (this.isReadOnly) {
                throw new PropertyNotWritableException();
            }
            try {
                ((List)base).set(index, val);
            }
            catch (UnsupportedOperationException ex) {
                throw new PropertyNotWritableException();
            }
            catch (IndexOutOfBoundsException ex) {
                throw new PropertyNotFoundException();
            }
            catch (ClassCastException | IllegalArgumentException | NullPointerException ex) {
                throw ex;
            }
        }
    }

    @Override
    public boolean isReadOnly(ExpressionContext context, Object base, Object property) {
        if (base instanceof List) {
            Objects.requireNonNull(context).setPropertyResolved(true);
            List list = (List)base;
            int index = this.toInteger(property);
            if (index < 0 || index >= list.size()) {
                throw new PropertyNotFoundException();
            }
            return list.getClass() == theUnmodifiableListClass || this.isReadOnly;
        }
        return false;
    }

    private int toInteger(Object p) {
        if (p instanceof Integer) {
            return (Integer)p;
        }
        if (p instanceof Character) {
            return ((Character)p).charValue();
        }
        if (p instanceof Number) {
            return ((Number)p).intValue();
        }
        if (p instanceof String) {
            return Integer.parseInt((String)p);
        }
        throw new IllegalArgumentException();
    }
}

