/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression;

import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.ExpressionResolver;
import java.util.Objects;

public class CompositeExpressionResolver
extends ExpressionResolver {
    private int size;
    private ExpressionResolver[] elResolvers;

    public CompositeExpressionResolver() {
        this(6);
    }

    public CompositeExpressionResolver(int init) {
        this.size = 0;
        this.elResolvers = new ExpressionResolver[init];
    }

    public CompositeExpressionResolver(ExpressionResolver ... eLResolvers) {
        this.elResolvers = Objects.requireNonNull(eLResolvers);
        this.size = eLResolvers.length;
    }

    public void add(ExpressionResolver elResolver) {
        Objects.requireNonNull(elResolver);
        if (this.size >= this.elResolvers.length) {
            ExpressionResolver[] newResolvers = new ExpressionResolver[this.size + 1];
            System.arraycopy(this.elResolvers, 0, newResolvers, 0, this.size);
            this.elResolvers = newResolvers;
        }
        this.elResolvers[this.size++] = elResolver;
    }

    @Override
    public Object getValue(ExpressionContext context, Object base, Object property) {
        context.setPropertyResolved(false);
        int size = this.size;
        if (size > 0) {
            ExpressionResolver[] elResolvers = this.elResolvers;
            for (int i = 0; i < size; ++i) {
                Object value = elResolvers[i].getValue(context, base, property);
                if (!context.isPropertyResolved()) continue;
                return value;
            }
        }
        return null;
    }

    @Override
    public Object invoke(ExpressionContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        context.setPropertyResolved(false);
        int size = this.size;
        if (size > 0) {
            ExpressionResolver[] elResolvers = this.elResolvers;
            for (int i = 0; i < size; ++i) {
                Object value = elResolvers[i].invoke(context, base, method, paramTypes, params);
                if (!context.isPropertyResolved()) continue;
                return value;
            }
        }
        return null;
    }

    @Override
    public Class<?> getType(ExpressionContext context, Object base, Object property) {
        context.setPropertyResolved(false);
        int size = this.size;
        if (size > 0) {
            ExpressionResolver[] elResolvers = this.elResolvers;
            for (int i = 0; i < size; ++i) {
                Class<?> type = elResolvers[i].getType(context, base, property);
                if (!context.isPropertyResolved()) continue;
                return type;
            }
        }
        return null;
    }

    @Override
    public void setValue(ExpressionContext context, Object base, Object property, Object val) {
        context.setPropertyResolved(false);
        int size = this.size;
        if (size > 0) {
            ExpressionResolver[] elResolvers = this.elResolvers;
            for (int i = 0; i < size; ++i) {
                elResolvers[i].setValue(context, base, property, val);
                if (!context.isPropertyResolved()) continue;
                return;
            }
        }
    }

    @Override
    public boolean isReadOnly(ExpressionContext context, Object base, Object property) {
        context.setPropertyResolved(false);
        int size = this.size;
        if (size > 0) {
            ExpressionResolver[] elResolvers = this.elResolvers;
            for (int i = 0; i < size; ++i) {
                boolean readOnly = elResolvers[i].isReadOnly(context, base, property);
                if (!context.isPropertyResolved()) continue;
                return readOnly;
            }
        }
        return false;
    }

    @Override
    public Object convertToType(ExpressionContext context, Object obj, Class<?> targetType) {
        context.setPropertyResolved(false);
        int size = this.size;
        if (size > 0) {
            ExpressionResolver[] elResolvers = this.elResolvers;
            for (int i = 0; i < size; ++i) {
                Object value = elResolvers[i].convertToType(context, obj, targetType);
                if (!context.isPropertyResolved()) continue;
                return value;
            }
        }
        return null;
    }
}

