/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression;

import cn.taketoday.expression.BeanNameResolver;
import cn.taketoday.expression.ExpressionContext;
import cn.taketoday.expression.ExpressionResolver;
import java.util.Objects;

public class BeanNameExpressionResolver
extends ExpressionResolver {
    private final BeanNameResolver beanNameResolver;

    public BeanNameExpressionResolver(BeanNameResolver beanNameResolver) {
        this.beanNameResolver = beanNameResolver;
    }

    @Override
    public Object getValue(ExpressionContext context, Object base, Object property) {
        BeanNameResolver beanNameResolver;
        if (base == null && property instanceof String && (beanNameResolver = this.beanNameResolver).isNameResolved((String)property)) {
            Objects.requireNonNull(context).setPropertyResolved(base, property);
            return beanNameResolver.getBean((String)property);
        }
        return null;
    }

    @Override
    public void setValue(ExpressionContext context, Object base, Object property, Object value) {
        String beanName;
        BeanNameResolver beanNameResolver;
        if (base == null && property instanceof String && ((beanNameResolver = this.beanNameResolver).isNameResolved(beanName = (String)property) || beanNameResolver.canCreateBean(beanName))) {
            beanNameResolver.setBeanValue(beanName, value);
            Objects.requireNonNull(context).setPropertyResolved(base, property);
        }
    }

    @Override
    public Class<?> getType(ExpressionContext context, Object base, Object property) {
        if (base == null && property instanceof String && this.beanNameResolver.isNameResolved((String)property)) {
            Objects.requireNonNull(context).setPropertyResolved(true);
            return this.beanNameResolver.getBean((String)property).getClass();
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ExpressionContext context, Object base, Object property) {
        if (base == null && property instanceof String && this.beanNameResolver.isNameResolved((String)property)) {
            Objects.requireNonNull(context).setPropertyResolved(true);
            return this.beanNameResolver.isReadOnly((String)property);
        }
        return false;
    }
}

